/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.logic;

import com.trae.maze.logic.MazeData;
import com.trae.maze.logic.MazeManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class MazeRules {
    public static void applyEnterArmor(ServerPlayer player, int wins) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet;
        if (wins == 0) {
            return;
        }
        if (wins == 1) {
            helmet = new ItemStack((ItemLike)Items.f_42468_);
            chestplate = new ItemStack((ItemLike)Items.f_42469_);
            leggings = new ItemStack((ItemLike)Items.f_42470_);
            boots = new ItemStack((ItemLike)Items.f_42471_);
        } else if (wins == 2) {
            helmet = new ItemStack((ItemLike)Items.f_42472_);
            chestplate = new ItemStack((ItemLike)Items.f_42473_);
            leggings = new ItemStack((ItemLike)Items.f_42474_);
            boots = new ItemStack((ItemLike)Items.f_42475_);
        } else {
            helmet = new ItemStack((ItemLike)Items.f_42480_);
            chestplate = new ItemStack((ItemLike)Items.f_42481_);
            leggings = new ItemStack((ItemLike)Items.f_42482_);
            boots = new ItemStack((ItemLike)Items.f_42483_);
        }
        player.m_150109_().f_35975_.set(3, (Object)helmet);
        player.m_150109_().f_35975_.set(2, (Object)chestplate);
        player.m_150109_().f_35975_.set(1, (Object)leggings);
        player.m_150109_().f_35975_.set(0, (Object)boots);
    }

    public static void removeMazeArmor(ServerPlayer player) {
        player.m_150109_().f_35975_.set(3, (Object)ItemStack.f_41583_);
        player.m_150109_().f_35975_.set(2, (Object)ItemStack.f_41583_);
        player.m_150109_().f_35975_.set(1, (Object)ItemStack.f_41583_);
        player.m_150109_().f_35975_.set(0, (Object)ItemStack.f_41583_);
    }

    public static void incrementWinsAndTeleportOut(MazeData maze, ServerPlayer player) {
        maze.addWin(player.m_20148_());
        int wins = maze.getWins(player.m_20148_());
        player.m_213846_((Component)Component.m_237113_((String)("\ud83c\udf89 \u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c! \u0412\u044b \u043f\u0440\u043e\u0448\u043b\u0438 \u0443\u0440\u043e\u0432\u0435\u043d\u044c " + wins + "!")));
        if (maze.entrancePos != null) {
            player.m_6021_((double)maze.entrancePos.m_123341_(), (double)maze.entrancePos.m_123342_(), (double)maze.entrancePos.m_123343_());
        } else {
            player.m_6021_((double)player.m_284548_().m_220360_().m_123341_(), (double)player.m_284548_().m_220360_().m_123342_(), (double)player.m_284548_().m_220360_().m_123343_());
        }
    }

    public static void onPlayerAttacked(MazeManager manager, LivingAttackEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        String mazeName = manager.findMazeAtPosition(player.m_20183_());
        if (mazeName == null) {
            return;
        }
        MazeData maze = manager.getMaze(mazeName);
        if (maze == null) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (source instanceof Zombie) {
            int wins = maze.getWins(player.m_20148_());
            if (wins == 0) {
                event.setCanceled(false);
                return;
            }
            event.setCanceled(true);
            source.m_6074_();
            manager.addPlayerHit(player.m_20148_());
            int hits = manager.getPlayerHits(player.m_20148_());
            MazeRules.updateArmorState(player, wins, hits);
        }
    }

    private static void updateArmorState(Player player, int wins, int hits) {
        if (wins == 1) {
            if (hits >= 1) {
                MazeRules.removeMazeArmor((ServerPlayer)player);
            }
        } else if (wins == 2) {
            if (hits == 1) {
                player.m_150109_().f_35975_.set(1, (Object)ItemStack.f_41583_);
                player.m_150109_().f_35975_.set(0, (Object)ItemStack.f_41583_);
            } else if (hits >= 2) {
                MazeRules.removeMazeArmor((ServerPlayer)player);
            }
        } else if (wins >= 3) {
            if (hits == 1) {
                player.m_150109_().f_35975_.set(0, (Object)ItemStack.f_41583_);
            } else if (hits == 2) {
                player.m_150109_().f_35975_.set(2, (Object)ItemStack.f_41583_);
                player.m_150109_().f_35975_.set(1, (Object)ItemStack.f_41583_);
            } else if (hits >= 3) {
                MazeRules.removeMazeArmor((ServerPlayer)player);
            }
        }
    }
}

