/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.logic;

import com.trae.maze.logic.MazeData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;

public class MazeSavedData
extends SavedData {
    private final Map<String, MazeData> mazes = new HashMap<String, MazeData>();
    public Map<String, BlockPos> pendingPos1 = new HashMap<String, BlockPos>();
    public Map<String, BlockPos> pendingPos2 = new HashMap<String, BlockPos>();

    public MazeData getMaze(String name) {
        return this.mazes.get(name);
    }

    public MazeData createMaze(String name) {
        if (this.mazes.containsKey(name)) {
            return null;
        }
        MazeData maze = new MazeData(name);
        this.mazes.put(name, maze);
        this.m_77762_();
        return maze;
    }

    public boolean deleteMaze(String name) {
        if (this.mazes.remove(name) != null) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public Map<String, MazeData> getAllMazes() {
        return this.mazes;
    }

    public boolean checkCollision(BoundingBox newBox) {
        if (newBox == null) {
            return false;
        }
        for (MazeData maze : this.mazes.values()) {
            if (maze.pos1 == null || maze.pos2 == null) continue;
            int xMin = Math.min(maze.pos1.m_123341_(), maze.pos2.m_123341_());
            int yMin = Math.min(maze.pos1.m_123342_(), maze.pos2.m_123342_());
            int zMin = Math.min(maze.pos1.m_123343_(), maze.pos2.m_123343_());
            int xMax = Math.max(maze.pos1.m_123341_(), maze.pos2.m_123341_());
            int zMax = Math.max(maze.pos1.m_123343_(), maze.pos2.m_123343_());
            int height = Math.max(3, maze.height);
            int yMax = yMin + height - 1;
            BoundingBox existing = new BoundingBox(xMin, yMin, zMin, xMax, yMax, zMax);
            if (!existing.m_71049_(newBox)) continue;
            return true;
        }
        return false;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag mazesTag = new ListTag();
        for (MazeData maze : this.mazes.values()) {
            CompoundTag mazeTag = new CompoundTag();
            maze.save(mazeTag);
            mazesTag.add((Object)mazeTag);
        }
        tag.m_128365_("mazes", (Tag)mazesTag);
        CompoundTag p1Tag = new CompoundTag();
        this.pendingPos1.forEach((k, v) -> p1Tag.m_128356_(k, v.m_121878_()));
        tag.m_128365_("pendingPos1", (Tag)p1Tag);
        CompoundTag p2Tag = new CompoundTag();
        this.pendingPos2.forEach((k, v) -> p2Tag.m_128356_(k, v.m_121878_()));
        tag.m_128365_("pendingPos2", (Tag)p2Tag);
        return tag;
    }

    public static MazeSavedData load(CompoundTag tag) {
        MazeSavedData data = new MazeSavedData();
        if (tag.m_128441_("mazes")) {
            ListTag mazesTag = tag.m_128437_("mazes", 10);
            for (int i = 0; i < mazesTag.size(); ++i) {
                CompoundTag mazeTag = mazesTag.m_128728_(i);
                MazeData maze = MazeData.load(mazeTag);
                data.mazes.put(maze.name, maze);
            }
        }
        if (tag.m_128441_("pendingPos1")) {
            CompoundTag p1 = tag.m_128469_("pendingPos1");
            for (String k : p1.m_128431_()) {
                data.pendingPos1.put(k, BlockPos.m_122022_((long)p1.m_128454_(k)));
            }
        }
        if (tag.m_128441_("pendingPos2")) {
            CompoundTag p2 = tag.m_128469_("pendingPos2");
            for (String k : p2.m_128431_()) {
                data.pendingPos2.put(k, BlockPos.m_122022_((long)p2.m_128454_(k)));
            }
        }
        return data;
    }
}

