/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.net.packet;

import com.trae.maze.client.ClientHud;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CTimerPacket {
    private final int seconds;
    private final int wins;
    private final boolean isVisible;
    private final String durability;
    private final int lootSeconds;

    public S2CTimerPacket(int seconds, int wins, boolean isVisible, String durability, int lootSeconds) {
        this.seconds = seconds;
        this.wins = wins;
        this.isVisible = isVisible;
        this.durability = durability;
        this.lootSeconds = lootSeconds;
    }

    public S2CTimerPacket(FriendlyByteBuf buf) {
        this.seconds = buf.readInt();
        this.wins = buf.readInt();
        this.isVisible = buf.readBoolean();
        this.durability = buf.m_130277_();
        this.lootSeconds = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.seconds);
        buf.writeInt(this.wins);
        buf.writeBoolean(this.isVisible);
        buf.m_130070_(this.durability);
        buf.writeInt(this.lootSeconds);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientHud.update(this.seconds, this.wins, this.isVisible, this.durability, this.lootSeconds));
        context.get().setPacketHandled(true);
    }
}

