/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.world;

import com.trae.maze.logic.MazeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class LootManager {
    private static final LootManager INSTANCE = new LootManager();
    private final Random rand = new Random();
    private final List<BlockPos> placedChests = new ArrayList<BlockPos>();

    public static LootManager get() {
        return INSTANCE;
    }

    public void init(MinecraftServer server) {
    }

    public void clearAndPlaceLoot(ServerLevel level, BoundingBox box, MazeData maze) {
        if (box == null || maze == null) {
            return;
        }
        this.placedChests.clear();
        int targetChestCount = maze.getEffectiveChestCount();
        int chestsPlaced = 0;
        int y = box.m_162396_() + 1;
        for (int x = box.m_162395_() + 1; x < box.m_162399_() && chestsPlaced < targetChestCount; ++x) {
            for (int z = box.m_162398_() + 1; z < box.m_162401_() && chestsPlaced < targetChestCount; ++z) {
                BlockPos pos = new BlockPos(x, y, z);
                if (!level.m_8055_(pos).m_60713_(Blocks.f_50016_) || !this.isDeadEnd(level, pos) || !this.isFarEnoughFromOtherChests(pos, 5) || this.rand.nextInt(100) >= maze.lootChancePercent) continue;
                this.placeChest(level, pos);
                this.placedChests.add(pos);
                ++chestsPlaced;
            }
        }
    }

    private boolean isFarEnoughFromOtherChests(BlockPos pos, int minDistance) {
        for (BlockPos chest : this.placedChests) {
            if (!chest.m_123314_((Vec3i)pos, (double)minDistance)) continue;
            return false;
        }
        return true;
    }

    private boolean isDeadEnd(ServerLevel level, BlockPos pos) {
        int walls = 0;
        if (!level.m_8055_(pos.m_122029_()).m_60795_()) {
            ++walls;
        }
        if (!level.m_8055_(pos.m_122024_()).m_60795_()) {
            ++walls;
        }
        if (!level.m_8055_(pos.m_122019_()).m_60795_()) {
            ++walls;
        }
        if (!level.m_8055_(pos.m_122012_()).m_60795_()) {
            ++walls;
        }
        return walls >= 3;
    }

    private void placeChest(ServerLevel level, BlockPos pos) {
        level.m_7731_(pos, Blocks.f_50087_.m_49966_(), 3);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)be;
            chest.m_6836_(0, new ItemStack((ItemLike)Items.f_42411_));
            chest.m_6836_(1, new ItemStack((ItemLike)Items.f_42412_, 1));
            chest.m_6836_(2, new ItemStack((ItemLike)Items.f_42580_, 1 + this.rand.nextInt(3)));
            if (this.rand.nextInt(100) < 20) {
                ItemStack potion = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)potion, (Potion)Potions.f_43612_);
                chest.m_6836_(3, potion);
            }
            if (this.rand.nextInt(100) < 15) {
                chest.m_6836_(4, new ItemStack((ItemLike)Items.f_42436_, 1));
            }
        }
    }
}

