/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.world;

import com.trae.maze.config.MazeThemeManager;
import com.trae.maze.logic.MazeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.registries.ForgeRegistries;

public class MazeGenerator {
    public static void generate(ServerLevel level, BoundingBox box, MazeData data) {
        MazeGenerator.generate(level, box, data, false);
    }

    public static void generate(ServerLevel level, BoundingBox box, MazeData data, boolean preserveCenter) {
        block76: {
            int z;
            int yMax;
            int zMax;
            int xMax;
            block75: {
                int z2;
                int x;
                int xMin = box.m_162395_();
                xMax = box.m_162399_();
                int yMin = box.m_162396_();
                int zMin = box.m_162398_();
                zMax = box.m_162401_();
                int h = Math.max(3, data.height);
                yMax = yMin + h - 1;
                int width = xMax - xMin + 1;
                int depth = zMax - zMin + 1;
                int pathW = Math.max(1, data.pathWidth);
                int wallW = Math.max(1, data.wallWidth);
                Random rand = new Random();
                int insideW = width - 2;
                int insideD = depth - 2;
                double centerX = (double)(xMin + xMax) / 2.0;
                double centerZ = (double)(zMin + zMax) / 2.0;
                int roomR = Math.max(2, Math.min(insideW, insideD) / 6);
                for (x = xMin; x <= xMax; ++x) {
                    for (z2 = zMin; z2 <= zMax; ++z2) {
                        if (preserveCenter && data.isLifeRoom && data.hasRoom && Math.abs((double)x - centerX) <= (double)roomR && Math.abs((double)z2 - centerZ) <= (double)roomR) continue;
                        BlockPos floorPos = new BlockPos(x, yMin, z2);
                        level.m_7731_(floorPos, MazeGenerator.getBlockState(data, true, rand, false), 3);
                    }
                }
                for (x = xMin; x <= xMax; ++x) {
                    for (z2 = zMin; z2 <= zMax; ++z2) {
                        boolean isBorder;
                        if (preserveCenter && data.isLifeRoom && data.hasRoom && Math.abs((double)x - centerX) <= (double)roomR && Math.abs((double)z2 - centerZ) <= (double)roomR) continue;
                        boolean bl = isBorder = x == xMin || x == xMax || z2 == zMin || z2 == zMax;
                        if (!isBorder) continue;
                        for (int y = yMin + 1; y <= yMax; ++y) {
                            boolean isTop = y == yMax;
                            BlockState borderState = MazeGenerator.getBlockState(data, false, rand, isTop);
                            level.m_7731_(new BlockPos(x, y, z2), borderState, 3);
                        }
                    }
                }
                if (insideW >= pathW && insideD >= pathW) {
                    for (x = xMin + 1; x < xMax; ++x) {
                        for (z2 = zMin + 1; z2 < zMax; ++z2) {
                            if (preserveCenter && data.hasRoom && data.isLifeRoom && Math.abs((double)x - centerX) <= (double)roomR && Math.abs((double)z2 - centerZ) <= (double)roomR) continue;
                            for (int y = yMin + 1; y <= yMax; ++y) {
                                boolean isTopVal = y == yMax;
                                level.m_7731_(new BlockPos(x, y, z2), MazeGenerator.getBlockState(data, false, rand, isTopVal), 3);
                            }
                        }
                    }
                }
                int stride = pathW + wallW;
                int cols = (insideW + wallW) / stride;
                int rows = (insideD + wallW) / stride;
                if (cols < 1) {
                    cols = 1;
                }
                if (rows < 1) {
                    rows = 1;
                }
                boolean[][] visited = new boolean[cols][rows];
                ArrayList<Point> stack = new ArrayList<Point>();
                class Point {
                    int c;
                    int r;

                    Point(int c, int r) {
                        this.c = c;
                        this.r = r;
                    }
                }
                Point start = new Point(0, 0);
                stack.add(start);
                visited[0][0] = true;
                int carveMaxY = data.isClosed ? yMax - 1 : yMax;
                MazeGenerator.carveRectProtected(level, xMin + 1, zMin + 1, yMin + 1, carveMaxY, pathW, pathW, preserveCenter, data.isLifeRoom, data.hasRoom, centerX, centerZ, roomR);
                while (!stack.isEmpty()) {
                    int[][] deltas;
                    Point current = (Point)stack.get(stack.size() - 1);
                    ArrayList<Point> neighbors = new ArrayList<Point>();
                    for (int[] d : deltas = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}}) {
                        int nc = current.c + d[0];
                        int nr = current.r + d[1];
                        if (nc < 0 || nc >= cols || nr < 0 || nr >= rows || visited[nc][nr]) continue;
                        neighbors.add(new Point(nc, nr));
                    }
                    if (!neighbors.isEmpty()) {
                        Point next = (Point)neighbors.get(rand.nextInt(neighbors.size()));
                        visited[next.c][next.r] = true;
                        stack.add(next);
                        int cx = xMin + 1 + current.c * stride;
                        int cz = zMin + 1 + current.r * stride;
                        int nx = xMin + 1 + next.c * stride;
                        int nz = zMin + 1 + next.r * stride;
                        MazeGenerator.carveRectProtected(level, nx, nz, yMin + 1, carveMaxY, pathW, pathW, preserveCenter, data.isLifeRoom, data.hasRoom, centerX, centerZ, roomR);
                        if (next.c > current.c) {
                            MazeGenerator.carveRectProtected(level, cx + pathW, cz, yMin + 1, carveMaxY, wallW, pathW, preserveCenter, data.isLifeRoom, data.hasRoom, centerX, centerZ, roomR);
                            continue;
                        }
                        if (next.c < current.c) {
                            MazeGenerator.carveRectProtected(level, nx + pathW, nz, yMin + 1, carveMaxY, wallW, pathW, preserveCenter, data.isLifeRoom, data.hasRoom, centerX, centerZ, roomR);
                            continue;
                        }
                        if (next.r > current.r) {
                            MazeGenerator.carveRectProtected(level, cx, cz + pathW, yMin + 1, carveMaxY, pathW, wallW, preserveCenter, data.isLifeRoom, data.hasRoom, centerX, centerZ, roomR);
                            continue;
                        }
                        if (next.r >= current.r) continue;
                        MazeGenerator.carveRectProtected(level, nx, nz + pathW, yMin + 1, carveMaxY, pathW, wallW, preserveCenter, data.isLifeRoom, data.hasRoom, centerX, centerZ, roomR);
                        continue;
                    }
                    stack.remove(stack.size() - 1);
                }
                double cx = (double)(xMin + xMax) / 2.0;
                double cz = (double)(zMin + zMax) / 2.0;
                BlockPos centerPos = new BlockPos((int)cx, yMin, (int)cz);
                int roomRadius = 0;
                if (data.hasRoom) {
                    int minDim = Math.min(insideW, insideD);
                    roomRadius = Math.max(2, minDim / 6);
                    if (!preserveCenter || !data.isLifeRoom) {
                        int roomCarveMaxY = data.isClosed ? yMax - 1 : yMax;
                        MazeGenerator.carveRect(level, centerPos.m_123341_() - roomRadius, centerPos.m_123343_() - roomRadius, yMin + 1, roomCarveMaxY, roomRadius * 2 + 1, roomRadius * 2 + 1);
                    }
                    if (data.isLifeRoom && !preserveCenter) {
                        int r = roomRadius;
                        int cxInt = centerPos.m_123341_();
                        int czInt = centerPos.m_123343_();
                        for (int x2 = cxInt - r; x2 <= cxInt + r; ++x2) {
                            for (z = czInt - r; z <= czInt + r; ++z) {
                                level.m_7731_(new BlockPos(x2, yMin, z), Blocks.f_50440_.m_49966_(), 3);
                                if (Math.abs(x2 - cxInt) <= 1 && Math.abs(z - czInt) <= 1 || rand.nextInt(10) != 0) continue;
                                if (rand.nextInt(5) == 0 && Math.abs(x2 - cxInt) > 2) {
                                    level.m_7731_(new BlockPos(x2, yMin + 1, z), Blocks.f_49999_.m_49966_(), 3);
                                    level.m_7731_(new BlockPos(x2, yMin + 2, z), Blocks.f_49999_.m_49966_(), 3);
                                    level.m_7731_(new BlockPos(x2, yMin + 3, z), Blocks.f_50050_.m_49966_(), 3);
                                    for (Direction d : Direction.Plane.HORIZONTAL) {
                                        level.m_7731_(new BlockPos(x2, yMin + 2, z).m_121945_(d), Blocks.f_50050_.m_49966_(), 3);
                                    }
                                    continue;
                                }
                                if (rand.nextInt(4) == 0) {
                                    level.m_7731_(new BlockPos(x2, yMin + 1, z), (rand.nextBoolean() ? Blocks.f_50112_ : Blocks.f_50111_).m_49966_(), 3);
                                    continue;
                                }
                                level.m_7731_(new BlockPos(x2, yMin + 1, z), Blocks.f_50034_.m_49966_(), 3);
                            }
                        }
                        level.m_7731_(centerPos, Blocks.f_50273_.m_49966_(), 3);
                    }
                } else {
                    MazeGenerator.carveRect(level, centerPos.m_123341_(), centerPos.m_123343_(), yMin + 1, yMax, 1, 1);
                }
                if (data.erosion > 0.0f) {
                    Random erosionRand = new Random();
                    for (int x3 = xMin + 1; x3 < xMax; ++x3) {
                        for (int z3 = zMin + 1; z3 < zMax; ++z3) {
                            int erosionMaxY;
                            if (preserveCenter && data.isLifeRoom && data.hasRoom && Math.abs((double)x3 - centerX) <= (double)roomR && Math.abs((double)z3 - centerZ) <= (double)roomR) continue;
                            int n = erosionMaxY = data.isClosed ? yMax - 1 : yMax;
                            if (!(erosionRand.nextFloat() < data.erosion)) continue;
                            MazeGenerator.carveRect(level, x3, z3, yMin + 1, erosionMaxY, 1, 1);
                        }
                    }
                }
                int chestCount = data.getEffectiveChestCount();
                int chestsPlaced = 0;
                int lifeRoomChestsPlaced = 0;
                int attempts = 0;
                while (chestsPlaced < chestCount && attempts < 1000) {
                    int chestZ;
                    ++attempts;
                    int chestX = xMin + 2 + rand.nextInt(insideW - 2);
                    BlockPos pos = new BlockPos(chestX, yMin + 1, chestZ = zMin + 2 + rand.nextInt(insideD - 2));
                    if (!level.m_8055_(pos).m_60795_() || !level.m_8055_(pos.m_7495_()).m_280296_()) continue;
                    if (data.hasRoom) {
                        boolean inRoom;
                        int minDim = Math.min(insideW, insideD);
                        int r = Math.max(2, minDim / 6);
                        boolean bl = inRoom = Math.abs(chestX - centerPos.m_123341_()) <= r && Math.abs(chestZ - centerPos.m_123343_()) <= r;
                        if (data.isLifeRoom ? (inRoom ? preserveCenter || lifeRoomChestsPlaced >= data.lifeRoomChestCount : !data.lifeChests) : inRoom) continue;
                    }
                    level.m_7731_(pos, Blocks.f_50087_.m_49966_(), 3);
                    BlockEntity be = level.m_7702_(pos);
                    if (be instanceof ChestBlockEntity) {
                        ChestBlockEntity chest = (ChestBlockEntity)be;
                        ArrayList<Integer> slots = new ArrayList<Integer>();
                        for (int i = 0; i < 27; ++i) {
                            slots.add(i);
                        }
                        Collections.shuffle(slots, rand);
                        int sIdx = 0;
                        chest.m_6211_();
                        chest.m_6836_(((Integer)slots.get(sIdx++)).intValue(), new ItemStack((ItemLike)Items.f_42411_));
                        chest.m_6836_(((Integer)slots.get(sIdx++)).intValue(), new ItemStack((ItemLike)Items.f_42412_));
                        Item food = Items.f_42406_;
                        int rF = rand.nextInt(3);
                        if (rF == 0) {
                            food = Items.f_42580_;
                        } else if (rF == 1) {
                            food = Items.f_42582_;
                        }
                        chest.m_6836_(((Integer)slots.get(sIdx++)).intValue(), new ItemStack((ItemLike)food));
                        int size = width * depth;
                        int minR = 3;
                        int maxR = 6;
                        if (size > 500) {
                            minR = 6;
                            maxR = 12;
                        }
                        if (size > 2000) {
                            minR = 12;
                            maxR = 24;
                        }
                        int rsCount = minR + rand.nextInt(maxR - minR + 1);
                        chest.m_6836_(((Integer)slots.get(sIdx++)).intValue(), new ItemStack((ItemLike)Items.f_42451_, rsCount));
                        if (rand.nextFloat() < 0.3f && sIdx < 27) {
                            chest.m_6836_(((Integer)slots.get(sIdx++)).intValue(), new ItemStack((ItemLike)Items.f_42436_));
                        }
                        if (rand.nextFloat() < 0.3f && sIdx < 27) {
                            ItemStack potion = new ItemStack((ItemLike)Items.f_42589_);
                            PotionUtils.m_43549_((ItemStack)potion, (Potion)Potions.f_43612_);
                            chest.m_6836_(((Integer)slots.get(sIdx++)).intValue(), potion);
                        }
                    }
                    ++chestsPlaced;
                    if (!data.isLifeRoom || !data.hasRoom) continue;
                    int minDim = Math.min(insideW, insideD);
                    int r = Math.max(2, minDim / 6);
                    boolean inRoom = Math.abs(pos.m_123341_() - centerPos.m_123341_()) <= r && Math.abs(pos.m_123343_() - centerPos.m_123343_()) <= r;
                    if (!inRoom) continue;
                    ++lifeRoomChestsPlaced;
                }
                if (data.hasTorches) {
                    int maxY = data.isClosed ? yMax - 1 : yMax;
                    int torchY = Math.min(yMin + 4, maxY);
                    for (int x4 = xMin + 2; x4 <= xMax - 2; ++x4) {
                        block18: for (int z4 = zMin + 2; z4 <= zMax - 2; ++z4) {
                            BlockPos pos;
                            if (preserveCenter && data.isLifeRoom && data.hasRoom && Math.abs((double)x4 - centerX) <= (double)roomR && Math.abs((double)z4 - centerZ) <= (double)roomR) continue;
                            if (data.hasRoom) {
                                int minDim = Math.min(insideW, insideD);
                                int r = Math.max(2, minDim / 6) + 1;
                                if (Math.abs(x4 - centerPos.m_123341_()) <= r && Math.abs(z4 - centerPos.m_123343_()) <= r) {
                                    continue;
                                }
                            } else if (Math.abs(x4 - centerPos.m_123341_()) <= 1 && Math.abs(z4 - centerPos.m_123343_()) <= 1) continue;
                            if (x4 % 10 != 5 && z4 % 10 != 5 || !level.m_8055_(pos = new BlockPos(x4, torchY, z4)).m_60795_()) continue;
                            for (Direction dir : Direction.Plane.HORIZONTAL) {
                                BlockPos wallPos = pos.m_121945_(dir.m_122424_());
                                if (!level.m_8055_(wallPos).m_280296_()) continue;
                                level.m_7731_(pos, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)dir), 3);
                                continue block18;
                            }
                        }
                    }
                }
                if (data.isLifeRoom) {
                    data.entrancePos = new BlockPos((int)centerX, yMin + 1, (int)centerZ);
                    ArrayList<Integer> sides = new ArrayList<Integer>();
                    int pW = pathW;
                    int midX = (xMin + xMax) / 2;
                    int midZ = (zMin + zMax) / 2;
                    int offset = pW / 2;
                    if (data.exitsCount == 4) {
                        sides.add(0);
                        sides.add(1);
                        sides.add(2);
                        sides.add(3);
                    } else if (data.exitsCount == 1) {
                        sides.add(rand.nextInt(4));
                    } else if (data.exitsCount == 2) {
                        if (rand.nextBoolean()) {
                            sides.add(0);
                            sides.add(1);
                        } else {
                            sides.add(2);
                            sides.add(3);
                        }
                    } else if (data.exitsCount == 3) {
                        ArrayList<Integer> all = new ArrayList<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
                        all.remove(rand.nextInt(4));
                        sides.addAll(all);
                    }
                    int exitsMaxY = data.isClosed ? yMax - 1 : yMax;
                    Iterator iterator = sides.iterator();
                    while (iterator.hasNext()) {
                        int s = (Integer)iterator.next();
                        if (s == 0) {
                            MazeGenerator.carveRect(level, midX - offset, zMin, yMin + 1, exitsMaxY, pW, wallW);
                        }
                        if (s == 1) {
                            MazeGenerator.carveRect(level, midX - offset, zMax - wallW + 1, yMin + 1, exitsMaxY, pW, wallW);
                        }
                        if (s == 2) {
                            MazeGenerator.carveRect(level, xMin, midZ - offset, yMin + 1, exitsMaxY, wallW, pW);
                        }
                        if (s != 3) continue;
                        MazeGenerator.carveRect(level, xMax - wallW + 1, midZ - offset, yMin + 1, exitsMaxY, wallW, pW);
                    }
                } else {
                    int entranceZ = (zMin + zMax) / 2;
                    int entranceX = xMin;
                    int entZStart = entranceZ - pathW / 2;
                    if (entZStart < zMin + 1) {
                        entZStart = zMin + 1;
                    }
                    if (data.hasExits) {
                        MazeGenerator.carveRect(level, entranceX, entZStart, yMin + 1, yMax, 1, pathW);
                        MazeGenerator.carveRect(level, entranceX + 1, entZStart, yMin + 1, yMax, 1, pathW);
                        BlockPos signPos = new BlockPos(entranceX, yMin + 2, entZStart - 1);
                        level.m_7731_(signPos, (BlockState)Blocks.f_50158_.m_49966_().m_61124_((Property)WallSignBlock.f_58064_, (Comparable)Direction.SOUTH), 3);
                        BlockEntity signBE = level.m_7702_(signPos);
                        if (signBE instanceof SignBlockEntity) {
                            SignBlockEntity sign = (SignBlockEntity)signBE;
                            sign.m_277073_(text -> text.m_276913_(0, (Component)Component.m_237113_((String)data.name)), true);
                            sign.m_6596_();
                        }
                        data.entrancePos = new BlockPos(entranceX - 2, yMin + 1, entranceZ);
                    } else {
                        data.entrancePos = new BlockPos(entranceX + 2, yMin + 1, entranceZ);
                    }
                }
                if (!preserveCenter || !data.isLifeRoom) {
                    int bz;
                    int bx;
                    level.m_7731_(centerPos, Blocks.f_50273_.m_49966_(), 3);
                    for (bx = -1; bx <= 1; ++bx) {
                        for (bz = -1; bz <= 1; ++bz) {
                            level.m_7731_(centerPos.m_7918_(bx, -1, bz), Blocks.f_50075_.m_49966_(), 3);
                        }
                    }
                    for (bx = -2; bx <= 2; ++bx) {
                        for (bz = -2; bz <= 2; ++bz) {
                            level.m_7731_(centerPos.m_7918_(bx, -2, bz), Blocks.f_50075_.m_49966_(), 3);
                        }
                    }
                }
                data.center = centerPos;
                if (!data.isClosed) break block75;
                for (int x5 = xMin; x5 <= xMax; ++x5) {
                    for (z = zMin; z <= zMax; ++z) {
                        if (preserveCenter && data.isLifeRoom && data.hasRoom && Math.abs((double)x5 - centerX) <= (double)roomR && Math.abs((double)z - centerZ) <= (double)roomR) continue;
                        BlockPos topPos = new BlockPos(x5, yMax, z);
                        if (x5 == centerPos.m_123341_() && z == centerPos.m_123343_()) continue;
                        level.m_7731_(topPos, MazeGenerator.getBlockState(data, false, rand, true), 3);
                    }
                }
                break block76;
            }
            if (data.isClosed) break block76;
            for (int x = xMin; x <= xMax; ++x) {
                for (z = zMin; z <= zMax; ++z) {
                    BlockPos topPos = new BlockPos(x, yMax, z);
                    level.m_7731_(topPos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    private static void carveRect(ServerLevel level, int x, int z, int yStart, int yEnd, int w, int d) {
        for (int ix = 0; ix < w; ++ix) {
            for (int iz = 0; iz < d; ++iz) {
                for (int y = yStart; y <= yEnd; ++y) {
                    level.m_7731_(new BlockPos(x + ix, y, z + iz), Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    private static void carveRectProtected(ServerLevel level, int x, int z, int yStart, int yEnd, int w, int d, boolean preserveCenter, boolean isLifeRoom, boolean hasRoom, double centerX, double centerZ, int roomR) {
        if (!(preserveCenter && isLifeRoom && hasRoom)) {
            MazeGenerator.carveRect(level, x, z, yStart, yEnd, w, d);
            return;
        }
        for (int ix = 0; ix < w; ++ix) {
            for (int iz = 0; iz < d; ++iz) {
                int blockX = x + ix;
                int blockZ = z + iz;
                if (Math.abs((double)blockX - centerX) <= (double)roomR && Math.abs((double)blockZ - centerZ) <= (double)roomR) continue;
                for (int y = yStart; y <= yEnd; ++y) {
                    level.m_7731_(new BlockPos(blockX, y, blockZ), Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    private static BlockState getBlockState(MazeData data, boolean isFloor, Random rand, boolean isTop) {
        if (data.stoneChance > 0) {
            int r = rand.nextInt(3);
            if (r == 0) {
                return Blocks.f_50334_.m_49966_();
            }
            if (r == 1) {
                return Blocks.f_50228_.m_49966_();
            }
            return Blocks.f_50122_.m_49966_();
        }
        if (data.themeName != null && !data.themeName.isEmpty()) {
            String section = isFloor ? "floor" : (isTop ? "top" : "wall");
            BlockState fallback = Blocks.f_50069_.m_49966_();
            fallback = isFloor ? Blocks.f_50501_.m_49966_() : Blocks.f_50504_.m_49966_();
            return MazeThemeManager.getBlock(data.themeName, section, rand, fallback);
        }
        if (isFloor) {
            return Blocks.f_50501_.m_49966_();
        }
        if (data.stoneChance > 0) {
            if (rand.nextInt(100) < data.stoneChance) {
                int r = rand.nextInt(3);
                switch (r) {
                    case 0: {
                        return Blocks.f_50334_.m_49966_();
                    }
                    case 1: {
                        return Blocks.f_50228_.m_49966_();
                    }
                    case 2: {
                        return Blocks.f_50122_.m_49966_();
                    }
                }
            }
            return Blocks.f_50069_.m_49966_();
        }
        String name = isFloor ? data.floorColor : data.wallColor;
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name.toLowerCase()));
        if (b == null || b == Blocks.f_50016_) {
            b = isFloor ? Blocks.f_50501_ : Blocks.f_50504_;
        }
        return b.m_49966_();
    }
}

