/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.world;

import com.trae.maze.logic.MazeData;
import com.trae.maze.logic.MazeSavedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class ZombieManager {
    private static final ZombieManager INSTANCE = new ZombieManager();
    private final Random rand = new Random();
    private final Map<UUID, UUID> playerAttacker = new HashMap<UUID, UUID>();

    public static ZombieManager get() {
        return INSTANCE;
    }

    public void init(MinecraftServer server) {
    }

    public void tick(ServerLevel level, MazeSavedData savedData) {
        if (level.m_46467_() % 20L != 0L) {
            return;
        }
        for (MazeData maze : savedData.getAllMazes().values()) {
            if (!maze.running) continue;
            ArrayList toKill = new ArrayList();
            ArrayList mazeZombies = new ArrayList();
            level.m_143280_((EntityTypeTest)EntityType.f_20501_, e -> e.m_19880_().contains("MazeZombie_" + maze.name)).forEach(z -> {
                CompoundTag nbt = z.getPersistentData();
                if (nbt.m_128441_("SpawnTime")) {
                    long spawnTime = nbt.m_128454_("SpawnTime");
                    long ageSeconds = (System.currentTimeMillis() - spawnTime) / 1000L;
                    if (ageSeconds > (long)maze.zombieTtlSeconds) {
                        toKill.add(z);
                    } else {
                        boolean killing = false;
                        if (maze.isLifeRoom && maze.center != null && maze.hasRoom && maze.pos1 != null && maze.pos2 != null) {
                            int w = Math.abs(maze.pos1.m_123341_() - maze.pos2.m_123341_()) + 1;
                            int d = Math.abs(maze.pos1.m_123343_() - maze.pos2.m_123343_()) + 1;
                            int r = Math.max(2, Math.min(w - 2, d - 2) / 6);
                            if (z.m_20183_().m_123314_((Vec3i)maze.center, (double)(r + 1))) {
                                toKill.add(z);
                                killing = true;
                            }
                        }
                        if (!killing) {
                            mazeZombies.add(z);
                        }
                    }
                }
            });
            toKill.forEach(Entity::m_146870_);
            for (Player player : level.m_6907_()) {
                ArrayList<Zombie> zombiesTargetingPlayer = new ArrayList<Zombie>();
                for (Zombie zombie : mazeZombies) {
                    if (zombie.m_5448_() != player) continue;
                    zombiesTargetingPlayer.add(zombie);
                }
                if (zombiesTargetingPlayer.size() <= 1) continue;
                Zombie designated = (Zombie)zombiesTargetingPlayer.get(0);
                this.playerAttacker.put(player.m_20148_(), designated.m_20148_());
                for (int i = 1; i < zombiesTargetingPlayer.size(); ++i) {
                    Zombie extra = (Zombie)zombiesTargetingPlayer.get(i);
                    extra.m_6710_(null);
                    extra.m_21573_().m_26573_();
                }
            }
        }
    }

    public void respawnWave(ServerLevel level, BoundingBox box, MazeData maze, String mazeName) {
        if (box == null || maze == null) {
            return;
        }
        int limit = maze.getEffectiveZombieCount();
        int count = 0;
        int attempts = 0;
        int width = box.m_162399_() - box.m_162395_() + 1;
        int depth = box.m_162401_() - box.m_162398_() + 1;
        int size = width * depth;
        int minDistance = Math.max(5, Math.min(size / 15, 10));
        ArrayList<BlockPos> spawnedPositions = new ArrayList<BlockPos>();
        int yMin = box.m_162396_();
        int yMax = yMin + maze.height - 1;
        while (count < limit && attempts < limit * 20) {
            Zombie zombie;
            int insideD;
            int insideW;
            int r;
            ++attempts;
            int x = box.m_162395_() + 2 + this.rand.nextInt(Math.max(1, box.m_162399_() - box.m_162395_() - 3));
            int z = box.m_162398_() + 2 + this.rand.nextInt(Math.max(1, box.m_162401_() - box.m_162398_() - 3));
            int y = yMin + 1;
            BlockPos pos = new BlockPos(x, y, z);
            boolean tooClose = false;
            for (BlockPos existing : spawnedPositions) {
                if (!existing.m_123314_((Vec3i)pos, (double)minDistance)) continue;
                tooClose = true;
                break;
            }
            if (tooClose || maze.isLifeRoom && maze.center != null && maze.hasRoom && pos.m_123314_((Vec3i)maze.center, (double)((r = Math.max(2, Math.min(insideW = width - 2, insideD = depth - 2) / 6)) + 2)) || !level.m_8055_(pos).m_60713_(Blocks.f_50016_) || (zombie = (Zombie)EntityType.f_20501_.m_20615_((Level)level)) == null) continue;
            zombie.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.rand.nextFloat() * 360.0f, 0.0f);
            zombie.m_20049_("MazeZombie_" + mazeName);
            zombie.getPersistentData().m_128356_("SpawnTime", System.currentTimeMillis());
            double speed = 0.23;
            if (maze.difficulty == 1) {
                speed = 0.3;
            }
            if (maze.difficulty == 2) {
                speed = 0.4;
            }
            zombie.m_21051_(Attributes.f_22279_).m_22100_(speed);
            zombie.m_21051_(Attributes.f_22281_).m_22100_(100.0);
            zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
            level.m_7967_((Entity)zombie);
            spawnedPositions.add(pos);
            ++count;
        }
    }

    public void killAll(ServerLevel level, String mazeName) {
        ArrayList toKill = new ArrayList();
        level.m_143280_((EntityTypeTest)EntityType.f_20501_, e -> e.m_19880_().contains("MazeZombie_" + mazeName)).forEach(toKill::add);
        toKill.forEach(Entity::m_146870_);
    }
}

