/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.datafixer.DataFixerAPI;
import org.betterx.bclib.api.v2.datafixer.Patch;
import org.betterx.bclib.api.v2.datafixer.PatchDidiFailException;
import org.betterx.bclib.interfaces.PatchBiFunction;
import org.betterx.bclib.interfaces.PatchFunction;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.state.api.WorldConfig;
import org.jetbrains.annotations.NotNull;

public class MigrationProfile {
    final Set<ModCore> mods;
    final Map<String, String> idReplacements;
    final List<PatchFunction<CompoundTag, Boolean>> levelPatchers;
    final List<PatchBiFunction<ListTag, ListTag, Boolean>> statePatchers;
    final List<Patch> worldDataPatchers;
    final Map<ModCore, List<String>> worldDataIDPaths;
    private final CompoundTag config;
    private CompoundTag level;
    private File levelBaseDir;
    private boolean prePatchChangedLevelDat;
    private boolean didRunPrePatch;
    private Exception prePatchException;

    MigrationProfile(CompoundTag config, boolean applyAll) {
        this.config = config;
        this.mods = Collections.unmodifiableSet(Patch.getALL().stream().map(p -> p.modCore).collect(Collectors.toSet()));
        HashMap replacements = new HashMap();
        LinkedList levelPatches = new LinkedList();
        LinkedList worldDataPatches = new LinkedList();
        LinkedList statePatches = new LinkedList();
        HashMap worldDataIDPaths = new HashMap();
        for (ModCore modCore : this.mods) {
            Patch.getALL().stream().filter(p -> p.modCore.equals((Object)modCore)).forEach(patch -> {
                List<String> paths = patch.getWorldDataIDPaths();
                if (paths != null) {
                    worldDataIDPaths.put(modCore, paths);
                }
                if (applyAll || this.currentPatchLevel(modCore) < patch.level || patch.alwaysApply) {
                    replacements.putAll(patch.getIDReplacements());
                    if (patch.getLevelDatPatcher() != null) {
                        levelPatches.add(patch.getLevelDatPatcher());
                    }
                    if (patch.getWorldDataPatcher() != null) {
                        worldDataPatches.add(patch);
                    }
                    if (patch.getBlockStatePatcher() != null) {
                        statePatches.add(patch.getBlockStatePatcher());
                    }
                    DataFixerAPI.LOGGER.info("Applying " + String.valueOf(patch));
                } else {
                    DataFixerAPI.LOGGER.info("Ignoring " + String.valueOf(patch));
                }
            });
        }
        this.worldDataIDPaths = Collections.unmodifiableMap(worldDataIDPaths);
        this.idReplacements = Collections.unmodifiableMap(replacements);
        this.levelPatchers = Collections.unmodifiableList(levelPatches);
        this.worldDataPatchers = Collections.unmodifiableList(worldDataPatches);
        this.statePatchers = Collections.unmodifiableList(statePatches);
    }

    public static void fixCustomFolder(File dir) {
        if (!BCLib.isDevEnvironment()) {
            return;
        }
        MigrationProfile profile = Patch.createMigrationData();
        List<File> nbts = MigrationProfile.getAllNbts(dir, null);
        nbts.parallelStream().forEach(file -> {
            DataFixerAPI.LOGGER.info("Loading NBT " + String.valueOf(file));
            try {
                int idx;
                ListTag items;
                CompoundTag root = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                boolean[] changed = new boolean[]{false};
                int spawnerIdx = -1;
                if (root.contains("palette")) {
                    items = root.getList("palette", 10);
                    for (idx = 0; idx < items.size(); ++idx) {
                        CompoundTag tag = (CompoundTag)items.get(idx);
                        if (tag.contains("Name") && tag.getString("Name").equals("minecraft:spawner")) {
                            spawnerIdx = idx;
                        }
                        if (tag.contains("Name") && (tag.getString("Name").equals("minecraft:") || tag.getString("Name").equals(""))) {
                            System.out.println("Empty Name");
                        }
                        if (tag.contains("id") && (tag.getString("id").equals("minecraft:") || tag.getString("id").equals(""))) {
                            System.out.println("Empty ID");
                        }
                        changed[0] = changed[0] | profile.replaceStringFromIDs(tag, "Name");
                    }
                }
                if (spawnerIdx >= 0 && root.contains("blocks")) {
                    items = root.getList("blocks", 10);
                    for (idx = 0; idx < items.size(); ++idx) {
                        CompoundTag entity;
                        CompoundTag blockTag = (CompoundTag)items.get(idx);
                        if (!blockTag.contains("state") || blockTag.getInt("state") != spawnerIdx || !blockTag.contains("nbt")) continue;
                        CompoundTag nbt = blockTag.getCompound("nbt");
                        if (nbt.contains("SpawnData") && !(entity = nbt.getCompound("SpawnData")).contains("entity")) {
                            CompoundTag data = new CompoundTag();
                            data.put("entity", (Tag)entity);
                            nbt.put("SpawnData", (Tag)data);
                            changed[0] = true;
                        }
                        if (!nbt.contains("SpawnPotentials")) continue;
                        ListTag pots = nbt.getList("SpawnPotentials", 10);
                        for (Tag potItemIn : pots) {
                            CompoundTag potItem = (CompoundTag)potItemIn;
                            if (potItem.contains("Weight")) {
                                int weight = potItem.getInt("Weight");
                                potItem.putInt("weight", weight);
                                potItem.remove("Weight");
                                changed[0] = true;
                            }
                            if (!potItem.contains("Entity")) continue;
                            CompoundTag entity2 = potItem.getCompound("Entity");
                            CompoundTag data = new CompoundTag();
                            data.put("entity", (Tag)entity2);
                            potItem.put("data", (Tag)data);
                            potItem.remove("Entity");
                            changed[0] = true;
                        }
                    }
                }
                if (changed[0]) {
                    DataFixerAPI.LOGGER.info("Writing NBT " + String.valueOf(file));
                    NbtIo.writeCompressed((CompoundTag)root, (Path)file.toPath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static List<File> getAllNbts(File dir, List<File> list) {
        if (list == null) {
            list = new ArrayList<File>();
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                MigrationProfile.getAllNbts(file, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
            list.add(file);
        }
        return list;
    }

    public final CompoundTag getLevelDat(File levelBaseDir) {
        if (this.level == null || this.levelBaseDir == null || !this.levelBaseDir.equals(levelBaseDir)) {
            this.runPrePatches(levelBaseDir);
        }
        return this.level;
    }

    public final boolean isLevelDatChanged() {
        return this.prePatchChangedLevelDat;
    }

    public final File getLevelDatFile() {
        return new File(this.levelBaseDir, "level.dat");
    }

    public final Path getLevelDatPath() {
        return this.getLevelDatFile().toPath();
    }

    public final Exception getPrePatchException() {
        return this.prePatchException;
    }

    public final void runPrePatches(File levelBaseDir) {
        if (this.didRunPrePatch) {
            BCLib.LOGGER.warn("Already did run PrePatches for " + String.valueOf(this.levelBaseDir) + ".");
        }
        BCLib.LOGGER.info("Running Pre Patchers on " + String.valueOf(levelBaseDir));
        this.levelBaseDir = levelBaseDir;
        this.level = null;
        this.prePatchException = null;
        this.didRunPrePatch = true;
        this.prePatchChangedLevelDat = this.runPreLevelPatches(this.getLevelDatFile());
    }

    private boolean runPreLevelPatches(File levelDat) {
        try {
            this.level = NbtIo.readCompressed((Path)levelDat.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            boolean changed = this.patchLevelDat(this.level);
            return changed;
        }
        catch (IOException | PatchDidiFailException e) {
            this.prePatchException = e;
            return false;
        }
    }

    public final void markApplied() {
        for (ModCore modCore : this.mods) {
            DataFixerAPI.LOGGER.info("Updating Patch-Level for '{}' from {} to {}", new Object[]{modCore, Version.fromInt((int)this.currentPatchLevel(modCore)).toString(), Version.fromInt((int)Patch.maxPatchLevel(modCore)).toString()});
            if (this.config == null) continue;
            this.config.putString(modCore.modId, Patch.maxPatchVersion(modCore).toString());
        }
    }

    public Version currentPatchVersion(@NotNull ModCore modCore) {
        if (this.config == null || !this.config.contains(modCore.modId)) {
            return Version.ZERO;
        }
        return new Version(this.config.getString(modCore.modId));
    }

    public int currentPatchLevel(@NotNull ModCore modCore) {
        return this.currentPatchVersion(modCore).toInt();
    }

    public boolean hasAnyFixes() {
        boolean hasLevelDatPatches = this.didRunPrePatch ? this.prePatchChangedLevelDat : this.levelPatchers.size() > 0;
        return this.idReplacements.size() > 0 || hasLevelDatPatches || this.worldDataPatchers.size() > 0;
    }

    public String replaceStringFromIDs(@NotNull String val) {
        String replace = this.idReplacements.get(val);
        return replace;
    }

    public boolean replaceStringFromIDs(@NotNull CompoundTag tag, @NotNull String key) {
        if (!tag.contains(key)) {
            return false;
        }
        String val = tag.getString(key);
        String replace = this.idReplacements.get(val);
        if (replace != null) {
            DataFixerAPI.LOGGER.warn("Replacing ID '{}' with '{}'.", new Object[]{val, replace});
            tag.putString(key, replace);
            return true;
        }
        return false;
    }

    private boolean replaceIDatPath(@NotNull ListTag list, @NotNull String[] parts, int level) {
        boolean[] changed = new boolean[]{false};
        if (level == parts.length - 1) {
            DataFixerAPI.fixItemArrayWithID(list, changed, this, true);
        } else {
            list.forEach(inTag -> {
                changed[0] = changed[0] | this.replaceIDatPath((CompoundTag)inTag, parts, level + 1);
            });
        }
        return changed[0];
    }

    private boolean replaceIDatPath(@NotNull CompoundTag tag, @NotNull String[] parts, int level) {
        boolean changed = false;
        for (int i = level; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (tag.contains(part)) {
                byte type = tag.getTagType(part);
                if (type == 9) {
                    ListTag list = tag.getList(part, 10);
                    return this.replaceIDatPath(list, parts, i);
                }
                if (type != 10) continue;
                tag = tag.getCompound(part);
                continue;
            }
            return false;
        }
        if (tag != null && parts.length > 0) {
            String key = parts[parts.length - 1];
            byte type = tag.getTagType(key);
            if (type == 9) {
                ListTag list = tag.getList(key, 10);
                boolean[] _changed = new boolean[]{false};
                if (list.size() == 0) {
                    _changed[0] = DataFixerAPI.fixStringIDList(tag, key, this);
                } else {
                    DataFixerAPI.fixItemArrayWithID(list, _changed, this, true);
                }
                return _changed[0];
            }
            if (type == 8) {
                return this.replaceStringFromIDs(tag, key);
            }
            if (type == 10) {
                CompoundTag cTag = tag.getCompound(key);
                boolean[] _changed = new boolean[]{false};
                DataFixerAPI.fixID(cTag, _changed, this, true);
                return _changed[0];
            }
        }
        return false;
    }

    public boolean replaceIDatPath(@NotNull CompoundTag root, @NotNull String path) {
        String[] parts = path.split("\\.");
        return this.replaceIDatPath(root, parts, 0);
    }

    public boolean patchLevelDat(@NotNull CompoundTag level) throws PatchDidiFailException {
        boolean changed = false;
        for (PatchFunction<CompoundTag, Boolean> f : this.levelPatchers) {
            changed |= f.apply(level, this).booleanValue();
        }
        return changed;
    }

    public void patchWorldData() throws PatchDidiFailException {
        CompoundTag root;
        for (Patch patch : this.worldDataPatchers) {
            root = WorldConfig.getRootTag((ModCore)patch.modCore);
            boolean changed = patch.getWorldDataPatcher().apply(root, this);
            if (!changed) continue;
            WorldConfig.saveFile((ModCore)patch.modCore);
        }
        for (Map.Entry entry : this.worldDataIDPaths.entrySet()) {
            root = WorldConfig.getRootTag((ModCore)((ModCore)entry.getKey()));
            boolean[] changed = new boolean[]{false};
            ((List)entry.getValue()).forEach(path -> {
                changed[0] = changed[0] | this.replaceIDatPath(root, (String)path);
            });
            if (!changed[0]) continue;
            WorldConfig.saveFile((ModCore)((ModCore)entry.getKey()));
        }
    }

    public boolean patchBlockState(ListTag palette, ListTag states) throws PatchDidiFailException {
        boolean changed = false;
        for (PatchBiFunction<ListTag, ListTag, Boolean> f : this.statePatchers) {
            changed |= f.apply(palette, states, this).booleanValue();
        }
        return changed;
    }
}

