/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.bonemeal;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.api.v3.bonemeal.BonemealBlockSpreader;
import org.betterx.bclib.api.v3.bonemeal.EndStoneSpreader;
import org.betterx.bclib.api.v3.bonemeal.FeatureSpreader;
import org.betterx.bclib.api.v3.bonemeal.NetherrackSpreader;
import org.betterx.bclib.api.v3.bonemeal.TaggedBonemealBlockSpreader;
import org.betterx.bclib.api.v3.tag.BCLBlockTags;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BonemealAPI {
    public static BonemealAPI INSTANCE = new BonemealAPI();
    private final Map<TagKey<Block>, BonemealBlockSpreader> taggedSpreaders = new HashMap<TagKey<Block>, BonemealBlockSpreader>();
    private final Map<Block, FeatureSpreader> featureSpreaders = new HashMap<Block, FeatureSpreader>();

    private BonemealAPI() {
        this.addSpreadableBlocks(BCLBlockTags.BONEMEAL_TARGET_NETHERRACK, NetherrackSpreader.INSTANCE);
        this.addSpreadableBlocks(BCLBlockTags.BONEMEAL_TARGET_END_STONE, EndStoneSpreader.INSTANCE);
        this.addSpreadableBlocks(BCLBlockTags.BONEMEAL_TARGET_OBSIDIAN, BCLBlockTags.BONEMEAL_SOURCE_OBSIDIAN);
    }

    public void addSpreadableFeatures(Block target, @NotNull ConfiguredFeatureKey<?> spreadableFeature) {
        this.featureSpreaders.put(target, new FeatureSpreader(target, () -> spreadableFeature.getHolder(WorldState.allStageRegistryAccess())));
    }

    public void addSpreadableFeatures(Block target, @NotNull FeatureProvider spreadableFeature) {
        this.featureSpreaders.put(target, new FeatureSpreader(target, spreadableFeature));
    }

    public void addSpreadableBlocks(@NotNull TagKey<Block> targetTag, @NotNull TagKey<Block> sourceTag) {
        this.taggedSpreaders.put(targetTag, new TaggedBonemealBlockSpreader(sourceTag));
    }

    public void addSpreadableBlocks(@NotNull TagKey<Block> targetTag, @NotNull BonemealBlockSpreader spreader) {
        this.taggedSpreaders.put(targetTag, spreader);
    }

    @ApiStatus.Internal
    public BonemealBlockSpreader blockSpreaderForState(BlockGetter blockGetter, BlockPos pos, @NotNull BlockState state) {
        for (Map.Entry<TagKey<Block>, BonemealBlockSpreader> e : this.taggedSpreaders.entrySet()) {
            if (!state.is(e.getKey()) || !e.getValue().canSpreadAt(blockGetter, pos)) continue;
            return e.getValue();
        }
        return null;
    }

    @ApiStatus.Internal
    public FeatureSpreader featureSpreaderForState(@NotNull BlockState state) {
        return this.featureSpreaders.get(state.getBlock());
    }

    @ApiStatus.Internal
    public boolean runSpreaders(ItemStack itemStack, Level level, BlockPos blockPos, boolean forceBonemeal) {
        BlockState blockState = level.getBlockState(blockPos);
        BonemealBlockSpreader spreader = INSTANCE.blockSpreaderForState((BlockGetter)level, blockPos, blockState);
        if (spreader != null && spreader.isValidBonemealSpreadTarget((BlockGetter)level, blockPos, blockState, level.isClientSide)) {
            if (level instanceof ServerLevel && spreader.performBonemealSpread((ServerLevel)level, level.random, blockPos, blockState)) {
                itemStack.shrink(1);
            }
            return true;
        }
        FeatureSpreader fSpreader = INSTANCE.featureSpreaderForState(blockState);
        if (fSpreader != null && fSpreader.isValidBonemealTarget((LevelReader)level, blockPos, blockState)) {
            if (level instanceof ServerLevel) {
                if (forceBonemeal || fSpreader.isBonemealSuccess(level, level.random, blockPos, blockState)) {
                    fSpreader.performBonemeal((ServerLevel)level, level.random, blockPos, blockState);
                }
                itemStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface FeatureProvider {
        @Nullable
        public Holder<? extends ConfiguredFeature<?, ?>> getFeature();
    }
}

