/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.bonemeal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface BonemealGrassLike
extends BonemealableBlock {
    public BlockState getGrowableCoverState();

    public Block getHostBlock();

    public Holder<PlacedFeature> getCoverFeature();

    public List<ConfiguredFeature<?, ?>> getFlowerFeatures();

    default public boolean canGrowFlower(RandomSource random) {
        return random.nextInt(8) == 0;
    }

    default public boolean canGrowCover(RandomSource random) {
        return random.nextInt(10) == 0;
    }

    default public boolean isValidBonemealTarget(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return blockGetter.getBlockState(blockPos.above()).isAir();
    }

    default public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    default public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos above = pos.above();
        BlockState growableState = this.getGrowableCoverState();
        block0: for (int bonemealAttempt = 0; bonemealAttempt < 128; ++bonemealAttempt) {
            Holder boneFeature;
            BlockPos currentPos = above;
            for (int j = 0; j < bonemealAttempt / 16; ++j) {
                if (!serverLevel.getBlockState((currentPos = currentPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is(this.getHostBlock()) || serverLevel.getBlockState(currentPos).isCollisionShapeFullBlock((BlockGetter)serverLevel, currentPos)) continue block0;
            }
            BlockState currentState = serverLevel.getBlockState(currentPos);
            if (currentState.is(growableState.getBlock()) && this.canGrowCover(random)) {
                ((BonemealableBlock)growableState.getBlock()).performBonemeal(serverLevel, random, currentPos, currentState);
            }
            if (!currentState.isAir()) continue;
            if (this.canGrowFlower(random)) {
                List<ConfiguredFeature<?, ?>> list = this.getFlowerFeatures();
                if (list.isEmpty()) continue;
                boneFeature = ((RandomPatchConfiguration)list.get(0).config()).feature();
            } else {
                boneFeature = this.getCoverFeature();
            }
            ((PlacedFeature)boneFeature.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), random, currentPos);
        }
    }
}

