/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client;

import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.betterx.bclib.api.v2.ModIntegrationAPI;
import org.betterx.bclib.api.v2.PostInitAPI;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.client.models.CustomModelBakery;
import org.betterx.bclib.client.textures.AtlasSetManager;
import org.betterx.bclib.client.textures.SpriteLister;
import org.betterx.bclib.integration.modmenu.ModMenuEntryPoint;
import org.betterx.bclib.interfaces.CustomColorProvider;

@EventBusSubscriber(modid="bclib", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BCLibClient {
    private static CustomModelBakery modelBakery;

    public static CustomModelBakery lazyModelbakery() {
        if (modelBakery == null) {
            modelBakery = new CustomModelBakery();
        }
        return modelBakery;
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        modelBakery = new CustomModelBakery();
        ModIntegrationAPI.registerAll();
        DataExchangeAPI.prepareClientside();
        PostInitAPI.postInit(true);
        ModMenuEntryPoint.register();
        AtlasSetManager.addSource(AtlasSetManager.VANILLA_BLOCKS, (SpriteSource)new SpriteLister("entity/chest"));
        AtlasSetManager.addSource(AtlasSetManager.VANILLA_BLOCKS, (SpriteSource)new SpriteLister("blocks"));
    }

    @SubscribeEvent
    public static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!(block instanceof CustomColorProvider)) continue;
            CustomColorProvider provider = (CustomColorProvider)block;
            event.register(provider.getProvider(), new Block[]{block});
        }
    }

    @SubscribeEvent
    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!(block instanceof CustomColorProvider)) continue;
            CustomColorProvider provider = (CustomColorProvider)block;
            event.register(provider.getItemProvider(), new ItemLike[]{block});
        }
    }
}

