/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.bclib.items.boat.CustomBoatTypeOverride;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class BoatRenderer {
    public static boolean render(Boat boat, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        CustomBoatTypeOverride cbto;
        BoatTypeOverride type;
        if (boat instanceof CustomBoatTypeOverride && (type = (cbto = (CustomBoatTypeOverride)boat).bcl_getCustomType()) != null) {
            float k;
            boolean hasChest = boat instanceof ChestBoat;
            poseStack.pushPose();
            poseStack.translate(0.0, 0.375, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f));
            float h = (float)boat.getHurtTime() - g;
            float j = boat.getDamage() - g;
            if (j < 0.0f) {
                j = 0.0f;
            }
            if (h > 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)h) * h * j / 10.0f * (float)boat.getHurtDir()));
            }
            if (!Mth.equal((float)(k = boat.getBubbleAngle(g)), (float)0.0f)) {
                poseStack.mulPose(new Quaternionf().setAngleAxis(boat.getBubbleAngle(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
            }
            ResourceLocation resourceLocation = hasChest ? type.chestBoatTexture : type.boatTexture;
            ListModel<Boat> boatModel = type.getBoatModel(hasChest);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            boatModel.setupAnim((Entity)boat, g, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(boatModel.renderType(resourceLocation));
            boatModel.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
            if (!boat.isUnderWater()) {
                VertexConsumer vertexConsumer2 = multiBufferSource.getBuffer(RenderType.waterMask());
                if (boatModel instanceof WaterPatchModel) {
                    WaterPatchModel waterPatchModel = (WaterPatchModel)boatModel;
                    waterPatchModel.waterPatch().render(poseStack, vertexConsumer2, i, OverlayTexture.NO_OVERLAY);
                }
            }
            poseStack.popPose();
            return true;
        }
        return false;
    }
}

