/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.furniture.block.AbstractChair;
import org.jetbrains.annotations.Nullable;

public class EntityChair
extends Entity {
    public EntityChair(EntityType<? extends EntityChair> type, Level world) {
        super(type, world);
    }

    protected int getMaxPassengers() {
        return 1;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.level().getBlockState(this.blockPosition()).getBlock() instanceof AbstractChair) {
            this.localTick();
        } else {
            BCLib.LOGGER.info("Chair Block was deleted -> ejecting");
            this.ejectPassengers();
            this.discard();
        }
    }

    protected void localTick() {
        super.tick();
        List pushableEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.7f, (double)-0.01f, (double)0.7f), EntitySelector.pushableBy((Entity)this));
        if (!pushableEntities.isEmpty()) {
            boolean free = !this.level().isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (int j = 0; j < pushableEntities.size(); ++j) {
                Entity entity = (Entity)pushableEntities.get(j);
                if (entity.hasPassenger((Entity)this)) continue;
                if (free && this.getPassengers().size() < this.getMaxPassengers() && !entity.isPassenger() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.startRiding((Entity)this);
                    continue;
                }
                this.push(entity);
            }
        }
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() < this.getMaxPassengers();
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity e : this.getPassengers()) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)e;
            return le;
        }
        return null;
    }

    public void push(Entity entity) {
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return Vec3.ZERO;
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static AttributeSupplier getAttributeContainer() {
        return AttributeSupplier.builder().build();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }
}

