/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items;

import de.ambertation.wunderlib.math.Bounds;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.interfaces.AirSelectionItem;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.ui.ColorUtil;

public class DebugDataItem
extends Item
implements ItemModelProvider,
AirSelectionItem {
    public static final ResourceLocation DEFAULT_ICON = ResourceLocation.withDefaultNamespace((String)"stick");
    protected final DebugInteraction interaction;
    protected final ResourceLocation icon;
    public final boolean placeInAir;

    public static InteractionResult fillStructureEntityBounds(UseOnContext useOnContext, BlockEntity entity, BlockStatePredicate predicate, BlockState newState, boolean floodFill) {
        if (entity instanceof StructureBlockEntity) {
            StructureBlockEntity e = (StructureBlockEntity)entity;
            if (floodFill) {
                DebugDataItem.floodFillStructureEntityBounds(useOnContext, e, predicate, newState);
            } else {
                DebugDataItem.fillStructureEntityBounds(useOnContext, e, predicate, newState);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static void fillStructureEntityBounds(UseOnContext useOnContext, StructureBlockEntity entity, BlockStatePredicate predicate, BlockState newState) {
        Level level = useOnContext.getLevel();
        Vec3i size = entity.getStructureSize();
        BlockPos pos = useOnContext.getClickedPos().offset((Vec3i)entity.getStructurePos());
        for (int x = 0; x < size.getX(); ++x) {
            for (int y = 0; y < size.getY(); ++y) {
                for (int z = 0; z < size.getZ(); ++z) {
                    BlockPos blockPos = pos.offset(x, y, z);
                    BlockState state = level.getBlockState(blockPos);
                    if (!predicate.test(state)) continue;
                    level.setBlock(blockPos, newState, 18);
                }
            }
        }
    }

    public static void floodFillStructureEntityBounds(UseOnContext useOnContext, StructureBlockEntity entity, BlockStatePredicate predicate, BlockState newState) {
        Bounds bounds = Bounds.of((BlockPos)useOnContext.getClickedPos().offset((Vec3i)entity.getStructurePos()), (Vec3i)entity.getStructureSize());
        DebugDataItem.floodFillStructureEntityBounds(useOnContext.getLevel(), bounds, bounds.max.toBlockPos(), entity, predicate, newState, new HashSet<BlockPos>());
    }

    private static void floodFillStructureEntityBounds(Level level, Bounds bounds, BlockPos pos, StructureBlockEntity entity, BlockStatePredicate predicate, BlockState newState, Set<BlockPos> visited) {
        if (!bounds.isInside(pos)) {
            return;
        }
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        if (predicate.test(level.getBlockState(pos))) {
            level.setBlock(pos, newState, 18);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.above(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.below(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.north(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.east(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.south(), entity, predicate, newState, visited);
            DebugDataItem.floodFillStructureEntityBounds(level, bounds, pos.west(), entity, predicate, newState, visited);
        }
    }

    public DebugDataItem(DebugEntityInteraction interaction, boolean placeInAir, ResourceLocation icon) {
        this((DebugInteraction)interaction, placeInAir, icon);
    }

    public DebugDataItem(DebugInteraction interaction, boolean placeInAir, ResourceLocation icon) {
        super(new Item.Properties().fireResistant().stacksTo(1));
        this.interaction = interaction;
        this.icon = icon == null ? DEFAULT_ICON : icon;
        this.placeInAir = placeInAir;
    }

    @Override
    public boolean renderAirSelection() {
        return this.placeInAir;
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.createItemModel(this.icon);
    }

    @Override
    public InteractionResult useOn(UseOnContext useOnContext) {
        if (!useOnContext.getPlayer().canUseGameMasterBlocks()) {
            return InteractionResult.FAIL;
        }
        return this.interaction.use(useOnContext);
    }

    public static void message(Player player, String text) {
        DebugDataItem.message(player, text, ColorUtil.GRAY);
    }

    public static void message(Player player, String text, int color) {
        DebugDataItem.message(player, (Component)Component.literal((String)text).withStyle(Style.EMPTY.withColor(color)));
    }

    public static void message(Player player, Component component) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.sendSystemMessage(component, true);
        }
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        return AirSelectionItem.super.useOnAir(level, player, interactionHand);
    }

    public static DebugDataItem forLootTable(ResourceKey<LootTable> table, Item icon) {
        ResourceLocation iconId = BuiltInRegistries.ITEM.getKey((Object)icon);
        return new DebugDataItem((player, entity, ctx) -> {
            CompoundTag tag = entity.saveWithoutMetadata((HolderLookup.Provider)player.registryAccess());
            tag.remove("LootTableSeed");
            tag.remove("Items");
            tag.putString("LootTable", table.location().toString());
            entity.loadCustomOnly(tag, (HolderLookup.Provider)player.registryAccess());
            DebugDataItem.message(player, "Did set Loot Table to " + table.toString());
            return InteractionResult.SUCCESS;
        }, false, iconId);
    }

    public static DebugDataItem forSpawner(Supplier<CompoundTag> tag, Item icon) {
        ResourceLocation iconId = BuiltInRegistries.ITEM.getKey((Object)icon);
        return new DebugDataItem((player, entity, ctx) -> {
            if (entity instanceof SpawnerBlockEntity) {
                entity.loadCustomOnly((CompoundTag)tag.get(), (HolderLookup.Provider)player.registryAccess());
                DebugDataItem.message(player, "Did set Data to " + tag.toString());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }, false, iconId);
    }

    public static DebugDataItem forSteetJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.EMPTY : pool, ResourceLocation.fromNamespaceAndPath((String)modID, (String)"street"), JigsawBlockEntity.JointType.ALIGNED, null, null, icon);
    }

    public static DebugDataItem forHouseEntranceJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.EMPTY : pool, pool == null ? ResourceLocation.fromNamespaceAndPath((String)modID, (String)"building_entrance") : ResourceLocation.fromNamespaceAndPath((String)modID, (String)"street_entrance"), pool == null ? ResourceLocation.fromNamespaceAndPath((String)modID, (String)"street_entrance") : ResourceLocation.fromNamespaceAndPath((String)modID, (String)"building_entrance"), JigsawBlockEntity.JointType.ALIGNED, null, null, icon);
    }

    public static DebugDataItem forDecorationJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.EMPTY : pool, pool == null ? ResourceLocation.fromNamespaceAndPath((String)modID, (String)"side") : ResourceLocation.fromNamespaceAndPath((String)modID, (String)"side_street"), pool == null ? ResourceLocation.fromNamespaceAndPath((String)modID, (String)"side_street") : ResourceLocation.fromNamespaceAndPath((String)modID, (String)"side"), JigsawBlockEntity.JointType.ALIGNED, null, null, icon);
    }

    public static DebugDataItem forStreetDecorationJigSaw(String modID, ResourceKey<StructureTemplatePool> pool, Item icon) {
        return DebugDataItem.forJigsaw(pool == null ? Pools.EMPTY : pool, pool == null ? ResourceLocation.fromNamespaceAndPath((String)modID, (String)"bottom") : ResourceLocation.fromNamespaceAndPath((String)modID, (String)"bottom_street"), pool == null ? ResourceLocation.fromNamespaceAndPath((String)modID, (String)"bottom_street") : ResourceLocation.fromNamespaceAndPath((String)modID, (String)"bottom"), JigsawBlockEntity.JointType.ROLLABLE, null, pool == null ? FrontAndTop.DOWN_WEST : FrontAndTop.UP_WEST, icon);
    }

    public static DebugDataItem forJigsaw(ResourceKey<StructureTemplatePool> pool, ResourceLocation connector, JigsawBlockEntity.JointType type, BlockState finalState, FrontAndTop forceOrientation, Item icon) {
        return DebugDataItem.forJigsaw(pool, connector, connector, type, finalState, forceOrientation, icon);
    }

    public static DebugDataItem forJigsaw(ResourceKey<StructureTemplatePool> pool, ResourceLocation name, ResourceLocation target, JigsawBlockEntity.JointType type, BlockState finalState, FrontAndTop forceOrientation, Item icon) {
        ResourceLocation iconId = BuiltInRegistries.ITEM.getKey((Object)icon);
        return new DebugDataItem(ctx -> {
            Player player = ctx.getPlayer();
            Level level = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            BlockState state = level.getBlockState(pos);
            BlockEntity entity = level.getBlockEntity(pos);
            BlockState targetState = finalState;
            if (!(entity instanceof JigsawBlockEntity)) {
                if (targetState == null) {
                    targetState = state.isAir() ? Blocks.STRUCTURE_VOID.defaultBlockState() : state;
                }
                state = Blocks.JIGSAW.defaultBlockState();
                level.setBlock(pos, state, 18);
                entity = level.getBlockEntity(pos);
                DebugDataItem.message(player, "Created JigSaw at " + pos.toString());
            }
            if (entity instanceof JigsawBlockEntity) {
                JigsawBlockEntity e = (JigsawBlockEntity)entity;
                state = forceOrientation == null ? PlaceCommand.setJigsawOrientation(JigsawBlockEntity.JointType.ROLLABLE != type, player, pos, state) : (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)forceOrientation);
                level.setBlock(pos, state, 18);
                if (pool != null) {
                    e.setName(name);
                }
                if (pool != null) {
                    e.setTarget(target);
                }
                if (pool != null) {
                    e.setPool(pool);
                }
                if (targetState != null) {
                    e.setFinalState(BlockStateParser.serialize((BlockState)targetState));
                }
                e.setJoint(type);
                DebugDataItem.message(player, "Did update Jigsaw at " + pos.toString());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }, true, iconId);
    }

    public static interface BlockStatePredicate {
        public boolean test(BlockState var1);
    }

    public static interface DebugInteraction {
        public InteractionResult use(UseOnContext var1);
    }

    public static interface DebugEntityInteraction
    extends DebugInteraction {
        @Override
        default public InteractionResult use(UseOnContext useOnContext) {
            BlockEntity entity = useOnContext.getLevel().getBlockEntity(useOnContext.getClickedPos());
            if (entity != null) {
                return this.use(useOnContext.getPlayer(), entity, useOnContext);
            }
            return InteractionResult.FAIL;
        }

        public InteractionResult use(Player var1, BlockEntity var2, UseOnContext var3);
    }
}

