/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Final
    @Shadow
    private BlockColors blockColors;
    @Final
    @Shadow
    private ItemColors itemColors;
    @Shadow
    @Nullable
    public Screen screen;

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void bclib_onMCInit(GameConfig args, CallbackInfo info) {
        BuiltInRegistries.BLOCK.forEach(block -> {
            if (block instanceof CustomColorProvider) {
                CustomColorProvider provider = (CustomColorProvider)block;
                this.blockColors.register(provider.getProvider(), new Block[]{block});
                this.itemColors.register(provider.getItemProvider(), new ItemLike[]{block.asItem()});
            }
        });
    }
}

