/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Recipe.class})
public interface RecipeMixin<C extends RecipeInput> {
    @Inject(method={"getRemainingItems"}, at={@At(value="RETURN")})
    default public void bcl_getRemainingItems(C container, CallbackInfoReturnable<NonNullList<ItemStack>> cir) {
        NonNullList remaining = (NonNullList)cir.getReturnValue();
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = container.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof PotionItem)) continue;
            PotionItem pi = (PotionItem)item;
            Optional potion = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion();
            if (!potion.map(p -> p == Potions.WATER).orElse(false).booleanValue()) continue;
            remaining.set(i, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
    }
}

