/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.registry;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;

@EventBusSubscriber(modid="bclib", bus=EventBusSubscriber.Bus.GAME)
public final class FuelRegistry {
    public static final FuelRegistry INSTANCE = new FuelRegistry();
    private final Map<Item, Integer> fuels = new IdentityHashMap<Item, Integer>();

    private FuelRegistry() {
    }

    public void add(ItemLike item, int burnTime) {
        this.fuels.put(item.asItem(), burnTime);
    }

    @SubscribeEvent
    public static void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        Integer burnTime = FuelRegistry.INSTANCE.fuels.get(stack.getItem());
        if (burnTime != null) {
            event.setBurnTime(burnTime.intValue());
        }
    }
}

