/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.bclib.worldgen;

import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.behaviours.interfaces.BehaviourCompostable;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.behaviours.interfaces.BehaviourSaplingLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourSeedLike;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BasePickaxeItem;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverAutoProvider;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.betterx.wover.tag.api.predefined.ToolTags;

public class BCLAutoItemTagProvider
extends WoverTagProvider.ForItems
implements WoverAutoProvider {
    public BCLAutoItemTagProvider(ModCore modCore) {
        super(modCore);
    }

    private static void processItemCommon(TagBootstrapContext<Item> context, Item item) {
        if (item instanceof BaseShovelItem) {
            context.add((Object)item, new TagKey[]{ToolTags.COMMON_SHOVELS, ItemTags.SHOVELS});
        } else if (item instanceof BaseSwordItem) {
            context.add((Object)item, new TagKey[]{ToolTags.COMMON_SWORDS, ItemTags.SWORDS});
        } else if (item instanceof BasePickaxeItem) {
            context.add((Object)item, new TagKey[]{ToolTags.COMMON_PICKAXES, ItemTags.PICKAXES});
        } else if (item instanceof BaseAxeItem) {
            context.add((Object)item, new TagKey[]{ToolTags.COMMON_AXES, ItemTags.AXES});
        } else if (item instanceof BaseHoeItem) {
            context.add((Object)item, new TagKey[]{ToolTags.COMMON_HOES, ItemTags.HOES});
        } else if (item instanceof BaseShearsItem) {
            context.add((Object)item, new TagKey[]{ToolTags.COMMON_SHEARS, CommonItemTags.SHEARS});
        }
    }

    private static void processBlockItemCommon(TagBootstrapContext<Item> context, Block block) {
        Item item = block.asItem();
        if (item == null || item == Items.AIR) {
            return;
        }
        if (block instanceof BehaviourCompostable) {
            BehaviourCompostable c = (BehaviourCompostable)block;
            context.add((Object)item, new TagKey[]{CommonItemTags.COMPOSTABLE});
        }
        if (block instanceof BehaviourSeedLike) {
            context.add((Object)item, new TagKey[]{CommonItemTags.SEEDS});
        }
        if (block instanceof BehaviourSaplingLike) {
            context.add((Object)item, new TagKey[]{CommonItemTags.SAPLINGS, ItemTags.SAPLINGS});
        }
        if (block instanceof BehaviourLeaves) {
            context.add((Object)item, new TagKey[]{ItemTags.LEAVES, CommonItemTags.LEAVES});
        }
    }

    private static void processBlockItemCommon(TagBootstrapContext<Item> context, ModCore modCore) {
        BCLib.C.LOG.debug("Processing Items for " + modCore.namespace);
        ItemRegistry.forMod((ModCore)modCore).allItems().forEach(item -> BCLAutoItemTagProvider.processItemCommon(context, item));
        BlockRegistry.forMod((ModCore)modCore).allBlocks().forEach(block -> BCLAutoItemTagProvider.processBlockItemCommon(context, block));
    }

    public void prepareTags(ItemTagBootstrapContext context) {
        BCLAutoItemTagProvider.processBlockItemCommon((TagBootstrapContext<Item>)context, this.modCore);
    }
}

