/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.builder.event.OnBootstrapBiomes;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.impl.BiomeManagerImpl;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeManager {
    public static final Event<OnBootstrapRegistry<Biome>> BOOTSTRAP_BIOME_REGISTRY = BiomeManagerImpl.BOOTSTRAP_BIOME_REGISTRY;
    public static final Event<OnBootstrapBiomes> BOOTSTRAP_BIOMES_WITH_DATA = BiomeManagerImpl.BOOTSTRAP_BIOMES_WITH_DATA;

    public static BiomeKey<BiomeBuilder.Vanilla> vanilla(ResourceLocation location) {
        return BiomeManagerImpl.vanilla(location);
    }

    public static BiomeKey<BiomeBuilder.Wrapped> wrapped(@NotNull ResourceKey<Biome> key) {
        return BiomeManagerImpl.wrapped(key);
    }

    @Nullable
    public static BiomeData biomeData(ResourceLocation biome) {
        return BiomeManager.biomeData((HolderLookup.Provider)WorldState.registryAccess(), biome);
    }

    public static BiomeData biomeData(HolderLookup.Provider registryAccess, ResourceLocation biome) {
        if (registryAccess == null) {
            return null;
        }
        return registryAccess.lookup(Registries.BIOME).flatMap(r -> r.get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome))).map(h -> BiomeManager.biomeDataForHolder(registryAccess, (Holder<Biome>)h)).orElse(null);
    }

    @Nullable
    public static BiomeData biomeDataForHolder(Holder<Biome> biome) {
        return BiomeManager.biomeDataForHolder((HolderLookup.Provider)WorldState.registryAccess(), biome);
    }

    @Nullable
    public static BiomeData biomeDataForHolder(HolderLookup.Provider acc, Holder<Biome> biome) {
        if (acc != null) {
            HolderLookup.RegistryLookup reg = acc.lookupOrThrow(BiomeDataRegistry.BIOME_DATA_REGISTRY);
            ResourceLocation id = biome.unwrapKey().map(ResourceKey::location).orElse(null);
            if (id != null) {
                return reg.get(BiomeDataRegistry.createKey(id)).map(Holder.Reference::value).orElse(null);
            }
        }
        return null;
    }

    public static void setBiome(ChunkAccess chunk, BlockPos pos, Holder<Biome> biome) {
        int sectionY = pos.getY() - chunk.getMinBuildHeight() >> 4;
        PalettedContainerRO biomes = chunk.getSection(sectionY).getBiomes();
        if (biomes instanceof PalettedContainer) {
            PalettedContainer palette = (PalettedContainer)biomes;
            palette.set((pos.getX() & 0xF) >> 2, (pos.getY() & 0xF) >> 2, (pos.getZ() & 0xF) >> 2, biome);
        } else {
            LibWoverBiome.C.LOG.warn("Unable to change Biome at " + String.valueOf(pos));
        }
    }

    public static void setBiome(LevelAccessor level, BlockPos pos, Holder<Biome> biome) {
        ChunkAccess chunk = level.getChunk(pos);
        BiomeManager.setBiome(chunk, pos, biome);
    }
}

