/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class BlockHelper {
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 18;
    public static final int SET_OBSERV = 3;
    public static final List<Direction> HORIZONTAL = List.of(Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH);
    public static final List<Direction> VERTICAL = List.of(Direction.UP, Direction.DOWN);
    public static final List<Direction> ALL = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN);

    public static boolean isFluid(BlockState state) {
        return state.liquid();
    }

    public static boolean isFreeOrFluid(BlockState state) {
        return state.isAir() || BlockHelper.isFluid(state);
    }

    public static boolean isTerrain(BlockState state) {
        return state.is(CommonBlockTags.TERRAIN);
    }

    @Deprecated(forRemoval=true)
    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 18);
    }

    public static boolean findOnSurroundingSurface(WorldGenLevel level, BlockPos.MutableBlockPos startPos, Direction dir, int length, BlockPredicate surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test((Object)level, (Object)startPos)) {
                if (len == 0) {
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.move(dir, -1);
                        if (surface.test((Object)level, (Object)startPos)) continue;
                        return true;
                    }
                    return false;
                }
                startPos.move(dir, -1);
                return true;
            }
            startPos.move(dir, 1);
        }
        return false;
    }

    public static Set<BlockState> getPossibleStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates());
    }
}

