/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;

abstract class ItemDescription<I extends Item> {
    public final I item;
    public final ResourceLocation location;

    public ItemDescription(ModCore modCore, String path, Supplier<I> creator, TagKey<Item> ... tags) {
        this.location = modCore.mk(path);
        this.item = (Item)creator.get();
        ItemRegistry.forMod(modCore).registerAsTool(path, this.item, tags);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean buildRecipe(Item tool, ItemLike stick, CraftingRecipeBuilder builder) {
        if (tool instanceof ShearsItem) {
            builder.shape(" #", "# ");
            return false;
        } else if (tool instanceof ArmorItem) {
            ArmorItem bai = (ArmorItem)tool;
            if (bai.getType().getSlot() == EquipmentSlot.FEET) {
                builder.shape("# #", "# #");
                return false;
            } else if (bai.getType().getSlot() == EquipmentSlot.HEAD) {
                builder.shape("###", "# #");
                return false;
            } else if (bai.getType().getSlot() == EquipmentSlot.CHEST) {
                builder.shape("# #", "###", "###");
                return false;
            } else {
                if (bai.getType().getSlot() != EquipmentSlot.LEGS) return true;
                builder.shape("###", "# #", "# #");
            }
            return false;
        } else {
            builder.addMaterial('I', stick);
            if (tool instanceof PickaxeItem) {
                builder.shape("###", " I ", " I ");
                return false;
            } else if (tool instanceof AxeItem) {
                builder.shape("##", "#I", " I");
                return false;
            } else if (tool instanceof HoeItem) {
                builder.shape("##", " I", " I");
                return false;
            } else if (tool instanceof ShovelItem) {
                builder.shape("#", "I", "I");
                return false;
            } else {
                if (!(tool instanceof SwordItem)) return true;
                builder.shape("#", "#", "I");
            }
        }
        return false;
    }

    public I getItem() {
        return this.item;
    }
}

