/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverRegistryProvider;
import org.jetbrains.annotations.ApiStatus;

public abstract class WoverFullRegistryProvider<T>
extends WoverRegistryProvider<T> {
    public final Predicate<String> validNamespace;

    public WoverFullRegistryProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey, Predicate<String> validNamespace) {
        super(modCore, title, registryKey);
        this.validNamespace = validNamespace;
    }

    public WoverFullRegistryProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey, List<String> validNamespaces) {
        this(modCore, title, registryKey, validNamespaces::contains);
    }

    public WoverFullRegistryProvider(ModCore modCore, String title, ResourceKey<Registry<T>> registryKey) {
        this(modCore, title, registryKey, List.of(modCore.namespace));
    }

    @Override
    protected abstract void bootstrap(BootstrapContext<T> var1);

    @Override
    @ApiStatus.Internal
    public final void buildRegistry(RegistrySetBuilder registryBuilder) {
        this.modCore.log.info("Registering " + this.title);
        registryBuilder.add(this.registryKey, this::bootstrap);
    }

    @Override
    @ApiStatus.Internal
    public DataProvider getProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, ExistingFileHelper existingFileHelper) {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        this.buildRegistry(registryBuilder);
        return new DatapackBuiltinEntriesProvider(output, registriesFuture, registryBuilder, this.modIdSet());
    }
}

