/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.entrypoint;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.generator.datagen.WoverWorldGeneratorDatagen;
import org.betterx.wover.generator.impl.biomesource.BiomeSourceManagerImpl;
import org.betterx.wover.generator.impl.biomesource.WoverBiomeDataImpl;
import org.betterx.wover.generator.impl.chunkgenerator.ChunkGeneratorManagerImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGeneratorImpl;
import org.betterx.wover.generator.impl.preset.PresetRegistryImpl;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoBuilder;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.WorldPresetTags;

public class LibWoverWorldGenerator {
    public static final ModCore C = ModCore.create("wover-generator", "wover");

    public LibWoverWorldGenerator(IEventBus modEventBus) {
        C.registerDatapackListener(modEventBus);
        modEventBus.addListener(new WoverWorldGeneratorDatagen()::onGatherData);
        modEventBus.addListener(RegisterEvent.class, BiomeSourceManagerImpl::register);
        modEventBus.addListener(RegisterEvent.class, ChunkGeneratorManagerImpl::onRegister);
        WorldPresetManager.BOOTSTRAP_WORLD_PRESETS.subscribe(PresetRegistryImpl::bootstrapWorldPresets);
        WorldPresetTags.TAGS.bootstrapEvent().subscribe(PresetRegistryImpl::bootstrapWorldPresetTags);
        WorldPresetInfoRegistry.BOOTSTRAP_WORLD_PRESET_INFO_REGISTRY.subscribe(LibWoverWorldGenerator::bootstrapPresetInfo);
        if (!ModCore.isClient() && ((Boolean)Configs.MAIN.forceDefaultWorldPresetOnServer.get()).booleanValue()) {
            WorldPresetManager.suggestDefault(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD, 2000);
        }
        PresetRegistryImpl.ensureStaticallyLoaded();
        WoverBiomeDataImpl.initialize();
        BiomeSourceManagerImpl.initialize();
        ChunkGeneratorManagerImpl.initialize();
        WoverChunkGeneratorImpl.initialize();
    }

    private static void bootstrapPresetInfo(BootstrapContext<WorldPresetInfo> context) {
        WorldPresetInfoBuilder.start(context).order(1500).overworldOverride((ResourceKey<WorldPreset>)WorldPresets.NORMAL).register(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD);
        WorldPresetInfoBuilder.start(context).order(2500).overworldOverride((ResourceKey<WorldPreset>)WorldPresets.AMPLIFIED).endOverride(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD).register(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD_AMPLIFIED);
        WorldPresetInfoBuilder.start(context).order(3500).overworldOverride((ResourceKey<WorldPreset>)WorldPresets.LARGE_BIOMES).register(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD_LARGE);
    }
}

