/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.features.config;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public abstract class PlaceBlockFeatureConfig
implements FeatureConfiguration {
    protected final BlockStateProvider stateProvider;

    protected static <T extends PlaceBlockFeatureConfig> RecordCodecBuilder<T, BlockStateProvider> blockStateCodec() {
        return BlockStateProvider.CODEC.fieldOf("entries").forGetter(o -> o.stateProvider);
    }

    protected static SimpleWeightedRandomList<BlockState> buildWeightedList(List<BlockState> states) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (BlockState s : states) {
            builder.add((Object)s, 1);
        }
        return builder.build();
    }

    protected static SimpleWeightedRandomList<BlockState> buildWeightedList(BlockState state) {
        return SimpleWeightedRandomList.builder().add((Object)state, 1).build();
    }

    public PlaceBlockFeatureConfig(Block block) {
        this(block.defaultBlockState());
    }

    public PlaceBlockFeatureConfig(BlockState state) {
        this((BlockStateProvider)BlockStateProvider.simple((BlockState)state));
    }

    public PlaceBlockFeatureConfig(List<BlockState> states) {
        this(PlaceBlockFeatureConfig.buildWeightedList(states));
    }

    public PlaceBlockFeatureConfig(SimpleWeightedRandomList<BlockState> blocks) {
        this.stateProvider = new WeightedStateProvider(blocks);
    }

    public PlaceBlockFeatureConfig(BlockStateProvider blocks) {
        this.stateProvider = blocks;
    }

    public BlockState getRandomBlock(RandomSource random, BlockPos pos) {
        return this.stateProvider.getState(random, pos);
    }

    public boolean place(FeaturePlaceContext<? extends PlaceBlockFeatureConfig> ctx) {
        BlockState state = this.getRandomBlock(ctx.random(), ctx.origin());
        return this.placeBlock(ctx, ctx.level(), ctx.origin(), state);
    }

    protected abstract boolean placeBlock(FeaturePlaceContext<? extends PlaceBlockFeatureConfig> var1, WorldGenLevel var2, BlockPos var3, BlockState var4);
}

