/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;

public class ExtendXYZ
extends PlacementModifier {
    public static final MapCodec<ExtendXYZ> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.codec((int)0, (int)16).fieldOf("radius").forGetter(cfg -> cfg.radius), (App)FloatProvider.codec((float)0.0f, (float)2.0f).optionalFieldOf("center_density", (Object)ConstantFloat.of((float)1.0f)).forGetter(cfg -> cfg.centerDensity), (App)FloatProvider.codec((float)0.0f, (float)2.0f).optionalFieldOf("border_density", (Object)ConstantFloat.of((float)0.05f)).forGetter(cfg -> cfg.borderDensity), (App)Codec.BOOL.optionalFieldOf("square", (Object)false).forGetter(cfg -> cfg.square), (App)FloatProvider.codec((float)0.0f, (float)30.0f).optionalFieldOf("height", (Object)ConstantFloat.of((float)1.0f)).forGetter(cfg -> cfg.heightScale), (App)HeightPropagation.CODEC.optionalFieldOf("height_propagation", (Object)HeightPropagation.NONE).forGetter(cfg -> cfg.heightPropagation)).apply((Applicative)instance, ExtendXYZ::new));
    private final IntProvider radius;
    private final FloatProvider centerDensity;
    private final FloatProvider borderDensity;
    private final boolean square;
    private final FloatProvider heightScale;
    private final HeightPropagation heightPropagation;

    public ExtendXYZ(IntProvider radius, FloatProvider centerDensity, FloatProvider borderDensity, boolean square, FloatProvider heightScale, HeightPropagation heightPropagation) {
        this.radius = radius;
        this.centerDensity = centerDensity;
        this.borderDensity = borderDensity;
        this.square = square;
        this.heightScale = heightScale;
        this.heightPropagation = heightPropagation;
    }

    public ExtendXYZ(IntProvider radius, FloatProvider centerDensity, FloatProvider borderDensity, boolean square) {
        this(radius, centerDensity, borderDensity, square, (FloatProvider)ConstantFloat.of((float)1.0f), HeightPropagation.NONE);
    }

    public static ExtendXYZ circle(IntProvider radius, FloatProvider centerDensity, FloatProvider borderDensity) {
        return new ExtendXYZ(radius, centerDensity, borderDensity, false);
    }

    public static ExtendXYZ spikedCircle(IntProvider radius, FloatProvider centerDensity, FloatProvider borderDensity, FloatProvider heightScale) {
        return new ExtendXYZ(radius, centerDensity, borderDensity, false, heightScale, HeightPropagation.SPIKES_DOWN);
    }

    public static ExtendXYZ square(IntProvider radius, FloatProvider centerDensity, FloatProvider borderDensity) {
        return new ExtendXYZ(radius, centerDensity, borderDensity, true);
    }

    private static void propagateSphere(RandomSource randomSource, Stream.Builder<BlockPos> builder, float maxR2, int maxDepth, int scale, float d0, float d1, float currentR2, float currentDensity, BlockPos pos, boolean didAdd) {
        int depth = (int)((float)maxDepth * (1.0f - currentR2 / maxR2));
        ExtendXYZ.propagateDown(randomSource, builder, d0, d1, currentDensity, pos, depth, scale);
    }

    private static void propagateSquare(RandomSource randomSource, Stream.Builder<BlockPos> builder, float maxR2, int maxDepth, int scale, float d0, float d1, float currentR2, float currentDensity, BlockPos pos, boolean didAdd) {
        ExtendXYZ.propagateDown(randomSource, builder, d0, d1, currentDensity, pos, maxDepth, scale);
    }

    private static void propagateSpikesConnected(RandomSource randomSource, Stream.Builder<BlockPos> builder, float maxR2, int maxDepth, int scale, float d0, float d1, float currentR2, float currentDensity, BlockPos pos, boolean didAdd) {
        if (!didAdd) {
            return;
        }
        ExtendXYZ.propagateDownConnected(randomSource, builder, d0, d1, currentDensity * currentDensity, pos, maxDepth, scale);
    }

    private static void propagateDownConnected(RandomSource randomSource, Stream.Builder<BlockPos> builder, float d0, float d1, float currentDensity, BlockPos pos, int depth, int scale) {
        int depth2 = depth * depth;
        for (int y = 1; y <= depth; ++y) {
            float lambda = (float)(y * y) / (float)depth2;
            float densityDown = (d0 + (d1 - d0) * lambda) * currentDensity;
            if ((double)densityDown <= 0.001) {
                return;
            }
            if (randomSource.nextFloat() > densityDown) {
                return;
            }
            builder.add(pos.above(scale * y));
        }
    }

    private static void propagateDown(RandomSource randomSource, Stream.Builder<BlockPos> builder, float d0, float d1, float currentDensity, BlockPos pos, int depth, int scale) {
        int depth2 = depth * depth;
        for (int y = 1; y <= depth; ++y) {
            float lambda = (float)(y * y) / (float)depth2;
            float densityDown = (d0 + (d1 - d0) * lambda) * currentDensity;
            if ((double)densityDown <= 0.001 || randomSource.nextFloat() > densityDown) continue;
            builder.add(pos.above(y * scale));
        }
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        Stream.Builder<BlockPos> builder = Stream.builder();
        int r = this.radius.sample(randomSource);
        float r2 = r * r;
        float d0 = this.centerDensity.sample(randomSource);
        float d1 = this.borderDensity.sample(randomSource);
        int height = (int)((float)r * this.heightScale.sample(randomSource));
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                float currentR2 = x * x + z * z;
                if (!this.square && currentR2 > r2) continue;
                float lambda = currentR2 / r2;
                float density = d0 + (d1 - d0) * lambda;
                BlockPos now = blockPos.offset(x, 0, z);
                if (density >= 1.0f || density > 0.001f && density >= randomSource.nextFloat()) {
                    builder.add(now);
                    this.heightPropagation.propagationFunction.propagate(randomSource, builder, r2, height, this.heightPropagation.scale, d0, d1, currentR2, density, now, true);
                    continue;
                }
                this.heightPropagation.propagationFunction.propagate(randomSource, builder, r2, height, this.heightPropagation.scale, d0, d1, currentR2, density, now, false);
            }
        }
        return builder.build();
    }

    @NotNull
    public PlacementModifierType<ExtendXYZ> type() {
        return PlacementModifiersImpl.EXTEND_XZ;
    }

    public static enum HeightPropagation implements StringRepresentable
    {
        NONE(1, (randomSource, builder, maxR2, maxDepth, scale1, d0, d1, currentR2, density, pos, didAdd) -> {}),
        BOX_DOWN(-1, ExtendXYZ::propagateSquare),
        BOX_UP(1, ExtendXYZ::propagateSquare),
        SPHERE_DOWN(-1, ExtendXYZ::propagateSphere),
        SPHERE_UP(1, ExtendXYZ::propagateSphere),
        SPIKES_DOWN(-1, ExtendXYZ::propagateSpikesConnected),
        SPIKES_UP(1, ExtendXYZ::propagateSpikesConnected);

        public static final Codec<HeightPropagation> CODEC;
        private final int scale;
        private final PropagationFunction propagationFunction;

        private HeightPropagation(int scale, PropagationFunction propagationFunction) {
            this.scale = scale;
            this.propagationFunction = propagationFunction;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(HeightPropagation::values);
        }
    }

    private static interface PropagationFunction {
        public void propagate(RandomSource var1, Stream.Builder<BlockPos> var2, float var3, int var4, int var5, float var6, float var7, float var8, float var9, BlockPos var10, boolean var11);
    }
}

