/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.block.api.predicate.BlockPredicates;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;

public class FindInDirection
extends PlacementModifier {
    public static final MapCodec<FindInDirection> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).optionalFieldOf("dir", List.of(Direction.DOWN)).forGetter(a -> a.directions), (App)Codec.intRange((int)1, (int)32).optionalFieldOf("dist", (Object)12).forGetter(p -> p.maxSearchDistance), (App)Codec.BOOL.optionalFieldOf("random_select", (Object)true).forGetter(p -> p.randomSelect), (App)Codec.INT.optionalFieldOf("offset_in_dir", (Object)0).forGetter(p -> p.offsetInDir), (App)BlockPredicate.CODEC.optionalFieldOf("surface_predicate", (Object)BlockPredicates.ONLY_GROUND).forGetter(p -> p.surfacePredicate)).apply((Applicative)instance, FindInDirection::new));
    private static final FindInDirection DOWN = new FindInDirection(Direction.DOWN, 6, 0, BlockPredicates.ONLY_GROUND);
    private static final FindInDirection UP = new FindInDirection(Direction.UP, 6, 0, BlockPredicates.ONLY_GROUND);
    private final List<Direction> directions;
    private final int maxSearchDistance;
    private final int offsetInDir;
    private final boolean randomSelect;
    private final IntProvider provider;
    private final BlockPredicate surfacePredicate;

    public FindInDirection(Direction direction, int maxSearchDistance, int offsetInDir, BlockPredicate surfacePredicate) {
        this(List.of(direction), maxSearchDistance, false, offsetInDir, surfacePredicate);
    }

    public FindInDirection(List<Direction> directions, int maxSearchDistance, int offsetInDir, BlockPredicate surfacePredicate) {
        this(directions, maxSearchDistance, directions.size() > 1, offsetInDir, surfacePredicate);
    }

    public FindInDirection(List<Direction> directions, int maxSearchDistance, boolean randomSelect, int offsetInDir, BlockPredicate surfacePredicate) {
        this.directions = directions;
        this.maxSearchDistance = maxSearchDistance;
        this.provider = UniformInt.of((int)0, (int)(this.directions.size() - 1));
        this.randomSelect = randomSelect;
        this.offsetInDir = offsetInDir;
        this.surfacePredicate = surfacePredicate;
    }

    public static PlacementModifier down() {
        return DOWN;
    }

    public static PlacementModifier up() {
        return UP;
    }

    public static PlacementModifier down(int dist) {
        if (dist == FindInDirection.DOWN.maxSearchDistance && 0 == FindInDirection.DOWN.offsetInDir) {
            return DOWN;
        }
        return new FindInDirection(Direction.DOWN, dist, 0, BlockPredicates.ONLY_GROUND);
    }

    public static PlacementModifier up(int dist) {
        if (dist == FindInDirection.UP.maxSearchDistance && 0 == FindInDirection.UP.offsetInDir) {
            return UP;
        }
        return new FindInDirection(Direction.UP, dist, 0, BlockPredicates.ONLY_GROUND);
    }

    public static PlacementModifier down(int dist, int offset) {
        if (dist == FindInDirection.DOWN.maxSearchDistance && 0 == FindInDirection.DOWN.offsetInDir) {
            return DOWN;
        }
        return new FindInDirection(Direction.DOWN, dist, offset, BlockPredicates.ONLY_GROUND);
    }

    public static PlacementModifier up(int dist, int offset) {
        if (dist == FindInDirection.UP.maxSearchDistance && offset == FindInDirection.UP.offsetInDir) {
            return UP;
        }
        return new FindInDirection(Direction.UP, dist, offset, BlockPredicates.ONLY_GROUND);
    }

    public Direction randomDirection(RandomSource random) {
        return this.directions.get(this.provider.sample(random));
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        Stream.Builder<BlockPos> builder = Stream.builder();
        if (this.randomSelect) {
            this.submitSingle(placementContext, blockPos, builder, this.randomDirection(randomSource));
        } else {
            for (Direction d : this.directions) {
                this.submitSingle(placementContext, blockPos, builder, d);
            }
        }
        return builder.build();
    }

    private void submitSingle(PlacementContext placementContext, BlockPos blockPos, Stream.Builder<BlockPos> builder, Direction searchDirection) {
        BlockPos.MutableBlockPos POS = blockPos.mutable();
        int searchDist = searchDirection == Direction.EAST ? Math.min(this.maxSearchDistance, 15 - SectionPos.sectionRelative((int)blockPos.getX())) : (searchDirection == Direction.WEST ? Math.min(this.maxSearchDistance, SectionPos.sectionRelative((int)blockPos.getX())) : (searchDirection == Direction.SOUTH ? Math.min(this.maxSearchDistance, 15 - SectionPos.sectionRelative((int)blockPos.getZ())) : (searchDirection == Direction.NORTH ? Math.min(this.maxSearchDistance, SectionPos.sectionRelative((int)blockPos.getZ())) : this.maxSearchDistance)));
        if (BlockHelper.findOnSurroundingSurface(placementContext.getLevel(), POS, searchDirection, searchDist, this.surfacePredicate)) {
            if (this.offsetInDir != 0) {
                builder.add((BlockPos)POS.move(searchDirection, this.offsetInDir));
            } else {
                builder.add((BlockPos)POS);
            }
        }
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifiersImpl.SOLID_IN_DIR;
    }
}

