/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.util.RandomizedWeightedList;
import org.jetbrains.annotations.Nullable;

public class WoverBiomePicker {
    private final Map<BiomeData, PickableBiome> registeredBiomes = new HashMap<BiomeData, PickableBiome>();
    public final HolderGetter<Biome> biomeRegistry;
    private final Set<PickableBiome> biomes = new HashSet<PickableBiome>();
    public final PickableBiome fallbackBiome;
    private RandomizedWeightedList.SearchTree tree;

    public WoverBiomePicker(ResourceKey<Biome> fallbackBiome) {
        this(WorldState.allStageRegistryAccess() == null ? null : (Registry)WorldState.allStageRegistryAccess().registry(Registries.BIOME).orElse(null), fallbackBiome);
    }

    public WoverBiomePicker(Registry<Biome> biomeRegistry, ResourceKey<Biome> fallbackBiome) {
        this((HolderGetter<Biome>)(biomeRegistry != null ? biomeRegistry.asLookup() : null), fallbackBiome);
    }

    public WoverBiomePicker(HolderGetter<Biome> biomeRegistry, ResourceKey<Biome> fallbackBiome) {
        this.biomeRegistry = biomeRegistry;
        this.fallbackBiome = this.create(BiomeData.tempOf(fallbackBiome));
    }

    public static void consumeSubBiomesForSource(BiomeData sourceBiome, BiConsumer<BiomeData, Float> consumeChild) {
        Registry<BiomeData> reg = WoverBiomeData.tryGetDataRegistry("biome alternatives", sourceBiome.biomeKey);
        if (reg == null) {
            return;
        }
        for (Map.Entry entry : reg.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof WoverBiomeData)) continue;
            WoverBiomeData b = (WoverBiomeData)v;
            if (!sourceBiome.isSame(b.parent)) continue;
            consumeChild.accept(b, Float.valueOf(b.genChance));
        }
    }

    private boolean isAllowed(BiomeData biomeData) {
        return biomeData != null;
    }

    private BiomeData nullIfNotAllowed(BiomeData biomeData) {
        return this.isAllowed(biomeData) ? biomeData : null;
    }

    private PickableBiome create(BiomeData biomeData) {
        if (biomeData == null) {
            return null;
        }
        PickableBiome e = this.registeredBiomes.get(biomeData);
        if (e != null && e.biomeData.isTemp() && !biomeData.isTemp()) {
            this.registeredBiomes.remove(e);
            e = null;
        }
        if (e != null) {
            return e;
        }
        return new PickableBiome(this, biomeData);
    }

    public void addBiome(BiomeData biome) {
        if (this.isAllowed(biome)) {
            this.biomes.add(this.create(biome));
        }
    }

    public PickableBiome getBiome(WorldgenRandom random) {
        return (PickableBiome)this.tree.getRandomValue((RandomSource)random);
    }

    public boolean isEmpty() {
        return this.biomes.isEmpty();
    }

    public void rebuild() {
        RandomizedWeightedList<PickableBiome> list = new RandomizedWeightedList<PickableBiome>();
        this.biomes.forEach(biome -> {
            if (biome.isValid) {
                list.add((PickableBiome)biome, biome.biomeData.genChance());
            }
        });
        if (list.isEmpty()) {
            list.add(this.fallbackBiome, 1.0);
        }
        if (WorldState.allStageRegistryAccess() != null) {
            int beforeSize = this.registeredBiomes.size();
            ArrayList<PickableBiome> beforeList = new ArrayList<PickableBiome>(this.registeredBiomes.values());
            for (PickableBiome builtBiome : beforeList) {
                WoverBiomePicker.consumeSubBiomesForSource(builtBiome.biomeData, (biomeData, weight) -> builtBiome.subbiomes.add(this.create((BiomeData)biomeData), weight.floatValue()));
            }
            if (this.registeredBiomes.size() != beforeSize) {
                LibWoverWorldGenerator.C.log.verbose("Added " + (this.registeredBiomes.size() - beforeSize) + " Biomes");
                for (PickableBiome builtBiome : new ArrayList<PickableBiome>(this.registeredBiomes.values())) {
                    if (beforeList.contains(builtBiome)) continue;
                    LibWoverWorldGenerator.C.log.verbose(" - " + String.valueOf(builtBiome.biomeData.biomeKey.location()) + ", subbiomes=" + builtBiome.subbiomes.size());
                }
            }
        }
        this.tree = list.buildSearchTree();
    }

    public String toString() {
        return "BiomePicker{biomes=" + this.biomes.size() + " (" + this.registeredBiomes.size() + "), biomeRegistry=" + String.valueOf(this.biomeRegistry) + ", type=" + super.toString() + "}";
    }

    @Nullable
    public static Holder<Biome> getBiomeAt(WorldGenLevel world, BlockPos testPos) {
        ChunkPos chunkPos = new ChunkPos(testPos);
        ChunkAccess chunk = world.getChunkSource().getChunk(chunkPos.x, chunkPos.z, ChunkStatus.BIOMES, false);
        if (chunk != null) {
            return chunk.getNoiseBiome(QuartPos.fromBlock((int)testPos.getX()), QuartPos.fromBlock((int)testPos.getY()), QuartPos.fromBlock((int)testPos.getZ()));
        }
        return null;
    }

    public class PickableBiome {
        public final BiomeData biomeData;
        public final Holder<Biome> biome;
        private final RandomizedWeightedList<PickableBiome> subbiomes;
        public final PickableBiome edge;
        public final PickableBiome parent;
        public final boolean isValid;
        public final int edgeSize;
        public final boolean isVertical;

        private PickableBiome(WoverBiomePicker this$0, BiomeData biomeData) {
            this$0.registeredBiomes.put(biomeData, this);
            this.biomeData = biomeData;
            this.biome = this$0.biomeRegistry != null ? this$0.biomeRegistry.getOrThrow(biomeData.biomeKey) : null;
            this.isValid = this.biome != null && this.biome.isBound();
            this.subbiomes = new RandomizedWeightedList();
            if (biomeData instanceof WoverBiomeData) {
                WoverBiomeData wData = (WoverBiomeData)biomeData;
                this.subbiomes.add(this, wData.genChance);
                this.edge = this$0.create(this$0.nullIfNotAllowed(wData.getEdgeData()));
                this.parent = this$0.create(wData.getParentData());
                this.edgeSize = wData.edgeSize;
                this.isVertical = wData.vertical;
            } else {
                this.subbiomes.add(this, 1.0);
                this.edge = null;
                this.parent = null;
                this.edgeSize = 0;
                this.isVertical = false;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickableBiome entry = (PickableBiome)o;
            return this.biomeData.equals(entry.biomeData);
        }

        public int hashCode() {
            return Objects.hash(this.biomeData);
        }

        public PickableBiome getSubBiome(WorldgenRandom random) {
            return this.subbiomes.getRandomValue((RandomSource)random);
        }

        public PickableBiome getEdge() {
            return this.edge;
        }

        public PickableBiome getParentBiome() {
            return this.parent;
        }

        public boolean isSame(PickableBiome e) {
            return this.biomeData.isSame(e.biomeData);
        }

        public String toString() {
            return "PickableBiome{key=" + String.valueOf(this.biomeData.biomeKey.location()) + ", alternatives=" + this.subbiomes.size() + ", edge=" + String.valueOf(this.edge != null ? this.edge.biomeData.biomeKey.location() : "null") + ", parent=" + String.valueOf(this.parent != null ? this.parent.biomeData.biomeKey.location() : "null") + ", isValid=" + this.isValid + "}";
        }
    }
}

