/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource.end;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;

public class TheEndBiomesHelper {
    private static final WeightedBiomeList MAIN_ISLAND = new WeightedBiomeList();
    private static final WeightedBiomeList HIGHLANDS = new WeightedBiomeList();
    private static final WeightedBiomeList SMALL_ISLANDS = new WeightedBiomeList();
    private static final WeightedBiomeList MIDLANDS_ALL = new WeightedBiomeList();
    private static final WeightedBiomeList BARRENS_ALL = new WeightedBiomeList();
    private static final Map<ResourceKey<Biome>, WeightedBiomeList> MIDLANDS_BY_HIGHLAND = new HashMap<ResourceKey<Biome>, WeightedBiomeList>();
    private static final Map<ResourceKey<Biome>, WeightedBiomeList> BARRENS_BY_HIGHLAND = new HashMap<ResourceKey<Biome>, WeightedBiomeList>();

    @ApiStatus.Internal
    public static synchronized void addMainIslandBiome(ResourceKey<Biome> biome, double weight) {
        MAIN_ISLAND.add(biome, weight);
    }

    @ApiStatus.Internal
    public static synchronized void addSmallIslandsBiome(ResourceKey<Biome> biome, double weight) {
        SMALL_ISLANDS.add(biome, weight);
    }

    @ApiStatus.Internal
    public static synchronized void addHighlandsBiome(ResourceKey<Biome> biome, double weight) {
        HIGHLANDS.add(biome, weight);
    }

    @ApiStatus.Internal
    public static synchronized void addMidlandsBiome(ResourceKey<Biome> highlands, ResourceKey<Biome> midlands, double weight) {
        if (highlands == null || midlands == null || weight <= 0.0) {
            return;
        }
        if (!HIGHLANDS.contains(highlands)) {
            HIGHLANDS.add(highlands, 1.0);
        }
        MIDLANDS_BY_HIGHLAND.computeIfAbsent(highlands, key -> new WeightedBiomeList()).add(midlands, weight);
        MIDLANDS_ALL.add(midlands, weight);
    }

    @ApiStatus.Internal
    public static synchronized void addBarrensBiome(ResourceKey<Biome> highlands, ResourceKey<Biome> barrens, double weight) {
        if (highlands == null || barrens == null || weight <= 0.0) {
            return;
        }
        if (!HIGHLANDS.contains(highlands)) {
            HIGHLANDS.add(highlands, 1.0);
        }
        BARRENS_BY_HIGHLAND.computeIfAbsent(highlands, key -> new WeightedBiomeList()).add(barrens, weight);
        BARRENS_ALL.add(barrens, weight);
    }

    public static boolean canGenerateAsMainIslandBiome(ResourceKey<Biome> biome) {
        return MAIN_ISLAND.contains(biome);
    }

    public static boolean canGenerateAsSmallIslandsBiome(ResourceKey<Biome> biome) {
        return SMALL_ISLANDS.contains(biome);
    }

    public static boolean canGenerateAsHighlandsBiome(ResourceKey<Biome> biome) {
        return HIGHLANDS.contains(biome);
    }

    public static boolean canGenerateAsEndMidlands(ResourceKey<Biome> biome) {
        return MIDLANDS_ALL.contains(biome);
    }

    public static boolean canGenerateAsEndBarrens(ResourceKey<Biome> biome) {
        return BARRENS_ALL.contains(biome);
    }

    public static boolean canGenerateInEnd(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.canGenerateAsHighlandsBiome(biome) || TheEndBiomesHelper.canGenerateAsEndBarrens(biome) || TheEndBiomesHelper.canGenerateAsEndMidlands(biome) || TheEndBiomesHelper.canGenerateAsSmallIslandsBiome(biome) || TheEndBiomesHelper.canGenerateAsMainIslandBiome(biome);
    }

    @ApiStatus.Internal
    public static ResourceKey<Biome> pickMainIslandKey(Climate.Sampler sampler, int x, int y, int z) {
        return MAIN_ISLAND.pick(TheEndBiomesHelper.selector(sampler, x, y, z));
    }

    @ApiStatus.Internal
    public static ResourceKey<Biome> pickSmallIslandsKey(Climate.Sampler sampler, int x, int y, int z) {
        return SMALL_ISLANDS.pick(TheEndBiomesHelper.selector(sampler, x, y, z));
    }

    @ApiStatus.Internal
    public static ResourceKey<Biome> pickHighlandsKey(Climate.Sampler sampler, int x, int y, int z) {
        return HIGHLANDS.pick(TheEndBiomesHelper.selector(sampler, x, y, z));
    }

    @ApiStatus.Internal
    public static ResourceKey<Biome> pickMidlandsKey(ResourceKey<Biome> highlands, Climate.Sampler sampler, int x, int y, int z) {
        WeightedBiomeList list = MIDLANDS_BY_HIGHLAND.get(highlands);
        ResourceKey<Biome> picked = list != null ? list.pick(TheEndBiomesHelper.selector(sampler, x, y, z)) : null;
        return picked != null ? picked : MIDLANDS_ALL.pick(TheEndBiomesHelper.selector(sampler, x, y, z));
    }

    @ApiStatus.Internal
    public static ResourceKey<Biome> pickBarrensKey(ResourceKey<Biome> highlands, Climate.Sampler sampler, int x, int y, int z) {
        WeightedBiomeList list = BARRENS_BY_HIGHLAND.get(highlands);
        ResourceKey<Biome> picked = list != null ? list.pick(TheEndBiomesHelper.selector(sampler, x, y, z)) : null;
        return picked != null ? picked : BARRENS_ALL.pick(TheEndBiomesHelper.selector(sampler, x, y, z));
    }

    @ApiStatus.Internal
    public static Holder<Biome> resolveHolder(ResourceKey<Biome> key, Holder<Biome> fallback) {
        if (key == null) {
            return fallback;
        }
        RegistryAccess access = WorldState.allStageRegistryAccess();
        Registry registry = access == null ? null : (Registry)access.registry(Registries.BIOME).orElse(null);
        return registry == null ? fallback : registry.getHolder(key).map(holder -> holder).orElse(fallback);
    }

    @ApiStatus.Internal
    public static void addAllPossibleBiomes(Collection<Holder<Biome>> holders) {
        Registry registry;
        RegistryAccess access = WorldState.allStageRegistryAccess();
        Registry registry2 = registry = access == null ? null : (Registry)access.registry(Registries.BIOME).orElse(null);
        if (registry == null) {
            return;
        }
        for (ResourceKey<Biome> key : TheEndBiomesHelper.allKeys()) {
            registry.getHolder(key).ifPresent(holders::add);
        }
    }

    private static synchronized Set<ResourceKey<Biome>> allKeys() {
        HashSet<ResourceKey<Biome>> keys = new HashSet<ResourceKey<Biome>>();
        keys.addAll(MAIN_ISLAND.keys());
        keys.addAll(SMALL_ISLANDS.keys());
        keys.addAll(HIGHLANDS.keys());
        keys.addAll(MIDLANDS_ALL.keys());
        keys.addAll(BARRENS_ALL.keys());
        return keys;
    }

    private static double selector(Climate.Sampler sampler, int x, int y, int z) {
        DensityFunction.SinglePointContext ctx = new DensityFunction.SinglePointContext(x, y, z);
        double noise = sampler.temperature().compute((DensityFunction.FunctionContext)ctx);
        return Mth.clamp((double)((noise + 1.0) / 2.0), (double)0.0, (double)1.0);
    }

    static {
        TheEndBiomesHelper.addMainIslandBiome((ResourceKey<Biome>)Biomes.THE_END, 1.0);
        TheEndBiomesHelper.addHighlandsBiome((ResourceKey<Biome>)Biomes.END_HIGHLANDS, 1.0);
        TheEndBiomesHelper.addMidlandsBiome((ResourceKey<Biome>)Biomes.END_HIGHLANDS, (ResourceKey<Biome>)Biomes.END_MIDLANDS, 1.0);
        TheEndBiomesHelper.addSmallIslandsBiome((ResourceKey<Biome>)Biomes.SMALL_END_ISLANDS, 1.0);
        TheEndBiomesHelper.addBarrensBiome((ResourceKey<Biome>)Biomes.END_HIGHLANDS, (ResourceKey<Biome>)Biomes.END_BARRENS, 1.0);
    }

    private static final class WeightedBiomeList {
        private final LinkedHashMap<ResourceKey<Biome>, Double> weights = new LinkedHashMap();
        private double totalWeight = 0.0;

        private WeightedBiomeList() {
        }

        void add(ResourceKey<Biome> biome, double weight) {
            if (biome == null || weight <= 0.0) {
                return;
            }
            double next = this.weights.getOrDefault(biome, 0.0) + weight;
            this.weights.put(biome, next);
            this.totalWeight += weight;
        }

        boolean contains(ResourceKey<Biome> biome) {
            return biome != null && this.weights.containsKey(biome);
        }

        Set<ResourceKey<Biome>> keys() {
            return this.weights.keySet();
        }

        ResourceKey<Biome> pick(double selector) {
            if (this.weights.isEmpty()) {
                return null;
            }
            double target = selector * this.totalWeight;
            ResourceKey<Biome> last = null;
            for (Map.Entry<ResourceKey<Biome>, Double> entry : this.weights.entrySet()) {
                last = entry.getKey();
                if (!((target -= entry.getValue().doubleValue()) <= 0.0)) continue;
                return entry.getKey();
            }
            return last;
        }
    }
}

