/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.loot.api;

import java.util.List;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.betterx.wover.loot.api.WoverVanillaBlockLoot;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.jetbrains.annotations.Nullable;

public class LootLookupProvider {
    public static final float[] VANILLA_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
    public static final float[] VANILLA_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    public final HolderLookup.Provider provider;
    private final WoverVanillaBlockLoot vanillaBlockLoot;
    public final HolderLookup.RegistryLookup<Enchantment> enchantmentLookup;

    public LootItemCondition.Builder hasSilkTouch() {
        return this.vanillaBlockLoot.hasSilkTouch();
    }

    public LootLookupProvider(HolderLookup.Provider provider) {
        this.vanillaBlockLoot = new WoverVanillaBlockLoot(provider);
        this.provider = provider;
        this.enchantmentLookup = provider.lookupOrThrow(Registries.ENCHANTMENT);
    }

    public Holder<Enchantment> enchantment(ResourceKey<Enchantment> key) {
        return this.enchantmentLookup.getOrThrow(key);
    }

    public Holder<Enchantment> fortune() {
        return this.enchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE);
    }

    public Holder<Enchantment> silkTouch() {
        return this.enchantment((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH);
    }

    public HolderLookup.Provider getProvider() {
        return this.provider;
    }

    public LootItemCondition.Builder silkTouchCondition() {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate(this.silkTouch(), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    public LootItemCondition.Builder shearsCondition() {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(CommonItemTags.SHEARS));
    }

    public LootItemCondition.Builder hoeCondition() {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.HOES));
    }

    public LootItemCondition.Builder shearsOrHoeSilkTouchCondition() {
        return this.shearsCondition().or((LootItemCondition.Builder)this.hoeCondition().or(this.silkTouchCondition()));
    }

    public LootItemCondition.Builder shearsOrSilkTouchCondition() {
        return this.shearsCondition().or(this.silkTouchCondition());
    }

    public LootItemCondition.Builder neitherShearsNorSilkTouchCondition() {
        return this.shearsOrSilkTouchCondition().invert();
    }

    public LootTable.Builder dropWithSilkTouch(ItemLike withSilkTouch) {
        return this.vanillaBlockLoot.createSilkTouchOnlyTable(withSilkTouch);
    }

    public LootTable.Builder dropWithSilkTouchOrHoeOrShears(ItemLike withSilkTouch) {
        return this.dropWithSilkTouchOrHoeOrShears(withSilkTouch, (NumberProvider)ConstantValue.exactly((float)1.0f));
    }

    public LootTable.Builder dropWithSilkTouchOrHoeOrShears(ItemLike withSilkTouch, NumberProvider rolls) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.shearsOrHoeSilkTouchCondition()).setRolls(rolls).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)withSilkTouch)));
    }

    public LootTable.Builder dropWithSilkTouchOrShears(ItemLike withSilkTouch) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.vanillaBlockLoot.hasShearsOrSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)withSilkTouch)));
    }

    public LootTable.Builder dropWithSilkTouch(Block withSilkTouch, ItemLike withoutSilkTouch, NumberProvider numberProvider) {
        return this.vanillaBlockLoot.createSingleItemTableWithSilkTouch(withSilkTouch, withoutSilkTouch, numberProvider);
    }

    public LootTable.Builder dropWithSilkTouch(Block withSilkTouch, List<DropInfo> withoutSilkTouch) {
        if (withoutSilkTouch.isEmpty()) {
            return this.dropWithSilkTouch((ItemLike)withSilkTouch);
        }
        LootTable.Builder mainBuilder = LootTable.lootTable();
        for (DropInfo dropInfo : withoutSilkTouch) {
            LootPoolSingletonContainer.Builder item = LootItem.lootTableItem((ItemLike)dropInfo.item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)dropInfo.numberProvider));
            LootLookupProvider.createSelfDropDispatchTable(mainBuilder, withSilkTouch, this.vanillaBlockLoot.hasSilkTouch(), (LootPoolEntryContainer.Builder)this.vanillaBlockLoot.applyExplosionDecay((ItemLike)withSilkTouch, item));
        }
        return mainBuilder;
    }

    protected static void createSelfDropDispatchTable(LootTable.Builder tableBuilder, Block block, LootItemCondition.Builder builder, LootPoolEntryContainer.Builder<?> builder2) {
        tableBuilder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(builder)).otherwise(builder2)));
    }

    public LootTable.Builder drop(ItemLike block) {
        return this.vanillaBlockLoot.createSingleItemTable(block);
    }

    public LootTable.Builder dropPottedContents(FlowerPotBlock block) {
        return this.vanillaBlockLoot.createPotFlowerItemTable((ItemLike)block.getPotted());
    }

    public LootTable.Builder dropOre(Block oreBlock, Item ore) {
        return this.vanillaBlockLoot.createOreDrop(oreBlock, ore);
    }

    public LootTable.Builder dropOre(Block oreBlock, Item ore, NumberProvider numberProvider) {
        return this.vanillaBlockLoot.createSilkTouchDispatchTable(oreBlock, (LootPoolEntryContainer.Builder)this.vanillaBlockLoot.applyExplosionDecay((ItemLike)oreBlock, LootItem.lootTableItem((ItemLike)ore).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)numberProvider)).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    public LootTable.Builder dropDoor(Block doorBlock) {
        return this.vanillaBlockLoot.createDoorTable(doorBlock);
    }

    public <T extends Comparable<T> & StringRepresentable> LootTable.Builder dropSingleWithCondition(Block block, Property<T> property, T comparable) {
        return this.vanillaBlockLoot.createSinglePropConditionTable(block, property, comparable);
    }

    public <T extends Comparable<T> & StringRepresentable> LootTable.Builder dropWithSilkTouchAndCondition(Block withSilkTouch, ItemLike withoutSilkTouch, NumberProvider numberProvider, Property<T> property, T comparable) {
        return this.vanillaBlockLoot.createSilkTouchDispatchTable(withSilkTouch, (LootPoolEntryContainer.Builder)this.vanillaBlockLoot.applyExplosionCondition((ItemLike)withSilkTouch, ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)withoutSilkTouch).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)withSilkTouch).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, comparable)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)numberProvider))));
    }

    public <T extends Comparable<T> & StringRepresentable> LootTable.Builder dropWithSilkTouchAndCondition(Block withSilkTouch, Property<T> property, T comparable) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.vanillaBlockLoot.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)withSilkTouch).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)withSilkTouch).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, comparable)))));
    }

    public LootTable.Builder dropPlant(Block plantBlock, ItemLike sapling) {
        return this.dropPlant(plantBlock, sapling, 0.125f, (NumberProvider)ConstantValue.exactly((float)1.0f), 2);
    }

    public LootTable.Builder dropPlant(Block plantBlock, ItemLike sapling, float saplingChance, NumberProvider saplingCount, int fortuneBonus) {
        return this.vanillaBlockLoot.createShearsDispatchTable(plantBlock, (LootPoolEntryContainer.Builder)this.vanillaBlockLoot.applyExplosionDecay((ItemLike)plantBlock, ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)sapling).when(LootItemRandomChanceCondition.randomChance((float)saplingChance))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)saplingCount)).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE), (int)fortuneBonus))));
    }

    public <T extends Comparable<T> & StringRepresentable> LootTable.Builder dropPlant(Block plantBlock, ItemLike fruit, ItemLike seed, Property<T> property, T comparable) {
        return this.dropPlant(plantBlock, fruit, (NumberProvider)ConstantValue.exactly((float)1.0f), seed, (NumberProvider)ConstantValue.exactly((float)1.0f), 0.571f, 3, property, comparable);
    }

    public LootTable.Builder dropPlant(Block plantBlock, ItemLike fruit, ItemLike seed, IntegerProperty property, int comparable) {
        return this.dropPlant(plantBlock, fruit, (NumberProvider)ConstantValue.exactly((float)1.0f), seed, (NumberProvider)ConstantValue.exactly((float)1.0f), 0.571f, 3, property, comparable);
    }

    public <T extends Comparable<T> & StringRepresentable> LootTable.Builder dropPlant(Block plantBlock, ItemLike fruit, NumberProvider fruitCount, ItemLike seed, NumberProvider seedCount, float probability, int extraRounds, Property<T> property, T comparable) {
        LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)plantBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, comparable));
        return this.dropPlant(plantBlock, fruit, fruitCount, seed, seedCount, probability, extraRounds, (LootItemCondition.Builder)condition);
    }

    public LootTable.Builder dropPlant(Block plantBlock, ItemLike fruit, NumberProvider fruitCount, ItemLike seed, NumberProvider seedCount, float probability, int extraRounds, IntegerProperty property, int comparable) {
        LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)plantBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)property, comparable));
        return this.dropPlant(plantBlock, fruit, fruitCount, seed, seedCount, probability, extraRounds, (LootItemCondition.Builder)condition);
    }

    public LootTable.Builder dropPlant(Block plantBlock, ItemLike fruit, NumberProvider fruitCount, ItemLike seed, NumberProvider seedCount, float probability, int extraRounds, LootItemCondition.Builder condition) {
        return (LootTable.Builder)this.vanillaBlockLoot.applyExplosionDecay((ItemLike)plantBlock, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)fruit).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)fruitCount)).when(condition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seed)))).withPool(LootPool.lootPool().when(condition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seed).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)seedCount)).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE), (float)probability, (int)extraRounds)))));
    }

    public LootTable.Builder dropLeaves(Block leaves, Block sapling) {
        return this.dropLeaves(leaves, sapling, VANILLA_LEAVES_SAPLING_CHANCES);
    }

    public LootTable.Builder dropLeaves(Block leaves, Block sapling, float ... saplingChances) {
        return this.vanillaBlockLoot.createLeavesDrops(leaves, sapling, saplingChances);
    }

    public LootTable.Builder dropLeaves(Block leaveBlock, ItemLike saplingBlock, int fortuneRate, int dropRate) {
        return this.dropLeaves(leaveBlock, saplingBlock, null, null, fortuneRate, dropRate);
    }

    public LootTable.Builder dropLeaves(Block leaveBlock, ItemLike saplingBlock, @Nullable ItemLike stickBlock, @Nullable NumberProvider stickCount, int fortuneRate, int dropRate) {
        float fortuneSaplingChance = 1.0f / (float)fortuneRate;
        float saplingChance = 1.0f / (float)dropRate;
        float[] fortuneSaplingChances = new float[]{0.8f * saplingChance, fortuneSaplingChance, 1.3333f * fortuneSaplingChance, 1.6666f * fortuneSaplingChance};
        LootTable.Builder baseBuilder = this.vanillaBlockLoot.createSilkTouchOrShearsDispatchTable(leaveBlock, ((LootPoolSingletonContainer.Builder)this.vanillaBlockLoot.applyExplosionCondition((ItemLike)leaveBlock, LootItem.lootTableItem((ItemLike)saplingBlock))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE), (float[])fortuneSaplingChances)));
        if (stickBlock != null) {
            if (stickCount == null) {
                stickCount = UniformGenerator.between((float)1.0f, (float)2.0f);
            }
            baseBuilder = baseBuilder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.vanillaBlockLoot.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.vanillaBlockLoot.applyExplosionDecay((ItemLike)leaveBlock, LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)stickCount)))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE), (float[])VANILLA_LEAVES_STICK_CHANCES))));
        }
        return baseBuilder;
    }

    public LootTable.Builder dropDoublePlantShears(Block block) {
        return this.vanillaBlockLoot.createDoublePlantShearsDrop(block);
    }

    public LootTable.Builder dropDoublePlantShears(Block block, Block seed) {
        return this.vanillaBlockLoot.createDoublePlantWithSeedDrops(block, seed);
    }

    public record DropInfo(ItemLike item, NumberProvider numberProvider) {
        public DropInfo(ItemLike item, int count) {
            this(item, (NumberProvider)ConstantValue.exactly((float)count));
        }
    }
}

