/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.recipe.api.CookingRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;

public class CookingRecipeBuilderImpl
extends BaseRecipeBuilderImpl<CookingRecipeBuilder>
implements CookingRecipeBuilder {
    protected float xp = 0.0f;
    protected int cookingTime = 200;
    protected Ingredient input;
    protected boolean blasting;
    protected boolean campfire;
    protected boolean smoker;
    protected boolean smelting;

    public CookingRecipeBuilderImpl(ResourceLocation id, ItemLike output, boolean blasting, boolean campfire, boolean smoker, boolean smelting) {
        super(id, output);
        this.blasting = blasting;
        this.campfire = campfire;
        this.smoker = smoker;
        this.smelting = smelting;
    }

    @Override
    public CookingRecipeBuilder experience(float xp) {
        this.xp = xp;
        return this;
    }

    @Override
    public CookingRecipeBuilder cookingTime(int time) {
        this.cookingTime = time;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableSmelter() {
        this.smelting = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableSmelter() {
        this.smelting = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableBlastFurnace() {
        this.blasting = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableBlastFurnace() {
        this.blasting = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableCampfire() {
        this.campfire = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableCampfire() {
        this.campfire = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableSmoker() {
        this.smoker = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableSmoker() {
        this.smoker = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder input(TagKey<Item> input) {
        return this.input(Ingredient.of(input));
    }

    @Override
    public CookingRecipeBuilder input(ItemLike input) {
        return this.input(Ingredient.of((ItemLike[])new ItemLike[]{input}));
    }

    @Override
    public CookingRecipeBuilder input(Ingredient input) {
        this.input = input;
        this.unlockedBy(input.getItems());
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (!(this.smelting || this.blasting || this.campfire || this.smoker)) {
            this.throwIllegalStateException("No target (smelting, blasting, campfire or somer) for cooking recipe was selected");
        }
        if (this.cookingTime < 0) {
            this.throwIllegalStateException("cooking time must be positive. Recipe {} will be ignored!");
        }
    }

    @Override
    public void build(RecipeOutput ctx) {
        if (this.smelting) {
            this.buildRecipe(ctx, "smelting", SimpleCookingRecipeBuilder.smelting((Ingredient)this.input, (RecipeCategory)this.category, (ItemLike)this.output.getItem(), (float)this.xp, (int)this.cookingTime));
        }
        if (this.blasting) {
            this.buildRecipe(ctx, "blasting", SimpleCookingRecipeBuilder.blasting((Ingredient)this.input, (RecipeCategory)this.category, (ItemLike)this.output.getItem(), (float)this.xp, (int)(this.cookingTime / 2)));
        }
        if (this.campfire) {
            this.buildRecipe(ctx, "campfire", SimpleCookingRecipeBuilder.campfireCooking((Ingredient)this.input, (RecipeCategory)this.category, (ItemLike)this.output.getItem(), (float)this.xp, (int)(this.cookingTime * 3)));
        }
        if (this.smoker) {
            this.buildRecipe(ctx, "smoker", SimpleCookingRecipeBuilder.campfireCooking((Ingredient)this.input, (RecipeCategory)this.category, (ItemLike)this.output.getItem(), (float)this.xp, (int)(this.cookingTime / 2)));
        }
    }

    private void buildRecipe(RecipeOutput ctx, String suffix, SimpleCookingRecipeBuilder builder) {
        ResourceLocation loc = this.id.withSuffix("_" + suffix);
        for (Map.Entry item : this.unlocks.entrySet()) {
            builder.unlockedBy((String)item.getKey(), (Criterion)item.getValue());
        }
        builder.save(ctx, loc);
    }
}

