/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.state.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.core.impl.registry.ModCoreImpl;
import org.betterx.wover.entrypoint.LibWoverEvents;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnWorldConfig;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.util.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WorldConfigImpl {
    private static final Map<ModCore, CompoundTag> TAGS = Maps.newHashMap();
    private static final List<ModCore> MODS = Lists.newArrayList();
    private static final Map<ModCore, EventImpl<OnWorldConfig>> EVENTS = Maps.newHashMap();
    private static final String TAG_CREATED = "create_version";
    private static final String TAG_MODIFIED = "modify_version";
    private static File dataDir;

    @ApiStatus.Internal
    public static void initialize() {
        WorldLifecycle.WORLD_FOLDER_READY.subscribe(WorldConfigImpl::loadForWorld, 100000000);
        WorldConfigImpl.registerMod(ModCoreImpl.GLOBAL_MOD);
        WorldConfigImpl.registerMod(LegacyHelper.BCLIB_CORE);
        WorldConfigImpl.registerMod(LegacyHelper.WORLDS_TOGETHER_CORE);
    }

    private static void loadForWorld(LevelStorageSource.LevelStorageAccess levelStorageAccess) {
        dataDir = levelStorageAccess.getLevelPath(LevelResource.ROOT).resolve("data").toFile();
        ArrayList eventQueue = new ArrayList(MODS.size());
        ((Stream)MODS.stream().parallel()).forEach(modCore -> {
            File file = new File(dataDir, modCore.modId + ".nbt");
            if (file.exists()) {
                try {
                    CompoundTag root = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.create((long)0x200000L));
                    TAGS.put((ModCore)modCore, root);
                    eventQueue.add(new Pair<ModCore, OnWorldConfig.State>((ModCore)modCore, OnWorldConfig.State.LOADED));
                }
                catch (IOException e) {
                    LibWoverEvents.C.log.error("World data loading failed", e);
                    eventQueue.add(new Pair<ModCore, OnWorldConfig.State>((ModCore)modCore, OnWorldConfig.State.LOAD_FAILED));
                }
            } else {
                CompoundTag root = WorldConfigImpl.setupNewConfig(modCore, false);
                if (modCore == LegacyHelper.BCLIB_CORE) {
                    root.putString("version", "9.9.9");
                }
                eventQueue.add(new Pair<ModCore, OnWorldConfig.State>((ModCore)modCore, OnWorldConfig.State.CREATED));
            }
        });
        eventQueue.forEach(pair -> EVENTS.computeIfPresent((ModCore)pair.first, (key, event) -> {
            event.emit(subscriber -> subscriber.config((ModCore)key, TAGS.get(key), (OnWorldConfig.State)((Object)((Object)((Object)((Object)pair.second))))));
            return event;
        }));
    }

    private static CompoundTag setupNewConfig(ModCore modCore, boolean emit) {
        CompoundTag root = new CompoundTag();
        TAGS.put(modCore, root);
        root.putString(TAG_CREATED, modCore.getModVersion().toString());
        root.putString(TAG_MODIFIED, modCore.getModVersion().toString());
        if (emit) {
            EVENTS.computeIfPresent(modCore, (key, event) -> {
                event.emit(subscriber -> subscriber.config(modCore, root, OnWorldConfig.State.CREATED));
                return event;
            });
        }
        return root;
    }

    public static void registerMod(ModCore modCore) {
        if (!MODS.contains(modCore)) {
            MODS.add(modCore);
        }
    }

    public static Event<OnWorldConfig> event(ModCore modCore) {
        return EVENTS.computeIfAbsent(modCore, key -> new EventImpl("WORLD_CONFIG_READY (" + key.modId + ")"));
    }

    public static CompoundTag getRootTag(ModCore modCore) {
        CompoundTag root = TAGS.get(modCore);
        if (root == null) {
            root = WorldConfigImpl.setupNewConfig(modCore, true);
        }
        return root;
    }

    public static boolean hasMod(ModCore modCore) {
        return MODS.contains(modCore);
    }

    @NotNull
    public static CompoundTag getCompoundTag(ModCore modCore, String path) {
        String[] parts = path.split("\\.");
        CompoundTag tag = WorldConfigImpl.getRootTag(modCore);
        for (String part : parts) {
            if (tag.contains(part)) {
                tag = tag.getCompound(part);
                continue;
            }
            CompoundTag t = new CompoundTag();
            tag.put(part, (Tag)t);
            tag = t;
        }
        return tag;
    }

    public static void saveFile(ModCore modCore) {
        if (!WorldConfigImpl.hasMod(modCore)) {
            LibWoverEvents.C.log.error("Mod " + modCore.modId + " is not registered for a worldconfig file");
            return;
        }
        try {
            if (dataDir != null && !dataDir.exists()) {
                dataDir.mkdirs();
            }
            CompoundTag tag = WorldConfigImpl.getRootTag(modCore);
            tag.putString(TAG_MODIFIED, modCore.getModVersion().toString());
            File tempFile = new File(dataDir, modCore.modId + "_temp.nbt");
            NbtIo.writeCompressed((CompoundTag)tag, (Path)tempFile.toPath());
            File oldFile = new File(dataDir, modCore.modId + "_old.nbt");
            File dataFile = new File(dataDir, modCore.modId + ".nbt");
            Util.safeReplaceFile((Path)dataFile.toPath(), (Path)tempFile.toPath(), (Path)oldFile.toPath());
        }
        catch (IOException e) {
            LibWoverEvents.C.log.error("World data saving failed", e);
        }
    }

    public static Version getModifiedVersion(ModCore modCore) {
        return new Version(WorldConfigImpl.getRootTag(modCore).getString(TAG_MODIFIED));
    }

    public static Version getCreatedVersion(ModCore modCore) {
        return new Version(WorldConfigImpl.getRootTag(modCore).getString(TAG_CREATED));
    }
}

