/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.conditions;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.wover.entrypoint.LibWoverSurface;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.surface.api.conditions.ConditionManager;
import org.betterx.wover.surface.impl.conditions.RoughNoiseConditionImpl;
import org.betterx.wover.surface.impl.conditions.ThresholdConditionImpl;
import org.betterx.wover.surface.impl.conditions.VolumeThresholdConditionImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MaterialConditionRegistryImpl {
    public static final ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> THRESHOLD_CONDITION = ConditionManager.createKey(LibWoverSurface.C.id("threshold_condition"));
    public static final ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> VOLUME_THRESHOLD_CONDITION = ConditionManager.createKey(LibWoverSurface.C.id("volume_threshold_condition"));
    public static final ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> ROUGH_NOISE_CONDITION = ConditionManager.createKey(LibWoverSurface.C.id("rough_noise_condition"));

    public static ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> register(ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> key, MapCodec<? extends SurfaceRules.ConditionSource> codec, boolean withBCLibLegacy) {
        return key;
    }

    @NotNull
    public static ResourceKey<MapCodec<? extends SurfaceRules.ConditionSource>> createKey(ResourceLocation location) {
        return ResourceKey.create((ResourceKey)Registries.MATERIAL_CONDITION, (ResourceLocation)location);
    }

    @ApiStatus.Internal
    public static void register(RegisterEvent event) {
        event.register(Registries.MATERIAL_CONDITION, helper -> {
            helper.register(THRESHOLD_CONDITION.location(), ThresholdConditionImpl.CODEC);
            helper.register(VOLUME_THRESHOLD_CONDITION.location(), VolumeThresholdConditionImpl.CODEC);
            helper.register(ROUGH_NOISE_CONDITION.location(), RoughNoiseConditionImpl.CODEC);
            if (LegacyHelper.isLegacyEnabled()) {
                helper.register(LegacyHelper.BCLIB_CORE.convertNamespace(THRESHOLD_CONDITION.location()), LegacyHelper.wrap(ThresholdConditionImpl.CODEC));
                helper.register(LegacyHelper.BCLIB_CORE.convertNamespace(VOLUME_THRESHOLD_CONDITION.location()), LegacyHelper.wrap(VolumeThresholdConditionImpl.CODEC));
                helper.register(LegacyHelper.BCLIB_CORE.convertNamespace(ROUGH_NOISE_CONDITION.location()), LegacyHelper.wrap(RoughNoiseConditionImpl.CODEC));
            }
        });
    }
}

