/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf.shapes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.Rotatable;
import de.ambertation.wunderlib.math.sdf.shapes.BaseShape;
import de.ambertation.wunderlib.math.sdf.shapes.Box;
import net.minecraft.util.KeyDispatchDataCodec;

public class Ellipsoid
extends BaseShape
implements Rotatable {
    public static final Transform DEFAULT_TRANSFORM = Box.DEFAULT_TRANSFORM;
    public static final MapCodec<Ellipsoid> DIRECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Transform.CODEC.fieldOf("transform").orElse((Object)Transform.IDENTITY).forGetter(o -> o.transform), (App)Codec.INT.fieldOf("material").orElse((Object)0).forGetter(BaseShape::getMaterialIndex)).apply((Applicative)instance, Ellipsoid::new));
    public static final KeyDispatchDataCodec<Ellipsoid> CODEC = KeyDispatchDataCodec.of(DIRECT_CODEC);

    @Override
    public KeyDispatchDataCodec<? extends SDF> codec() {
        return CODEC;
    }

    public Ellipsoid(Transform t, int matIndex) {
        super(t, matIndex);
    }

    public Ellipsoid(Transform t) {
        this(t, 0);
    }

    public Ellipsoid(Float3 center, Float3 size) {
        this(Transform.of(center, size), 0);
    }

    @Override
    public double dist(Float3 pos) {
        pos = this.getParentTransformMatrix().inverted().transform(pos);
        Float3 size = this.getSize().sub(1.0);
        pos = pos.sub(this.getCenter());
        double k1 = pos.div(size).length();
        double k2 = pos.div(size.square()).length();
        return k1 * (k1 - 1.0) / k2;
    }

    public Float3 getSize() {
        return this.transform.size;
    }

    @Override
    public Transform defaultTransform() {
        return DEFAULT_TRANSFORM;
    }
}

