/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.CustomRenderComponent;
import de.ambertation.wunderlib.ui.layout.components.render.RenderHelper;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HLine
extends CustomRenderComponent {
    private int color = ColorHelper.DEFAULT_TEXT;
    private boolean focused;

    public HLine(Value width, Value height) {
        super(width, height);
        this.vAlign = Alignment.CENTER;
        this.hAlign = Alignment.CENTER;
    }

    public HLine setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    protected void customRender(GuiGraphics guiGraphics, int x, int y, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
        int top = bounds.height - this.getContentHeight();
        if (this.vAlign == Alignment.CENTER) {
            top /= 2;
        } else if (this.vAlign == Alignment.MIN) {
            top = 0;
        }
        RenderHelper.hLine(guiGraphics, 0, bounds.width, top, this.color);
    }

    @Override
    public int getContentWidth() {
        return 0;
    }

    @Override
    public int getContentHeight() {
        return 1;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }
}

