/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.render.NullRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.ScrollerRenderer;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderlib.ui.vanilla.VanillaScrollerRenderer;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VerticalScroll<RS extends ScrollerRenderer>
extends LayoutComponent<NullRenderer, VerticalScroll<RS>>
implements ContainerEventHandler {
    protected LayoutComponent<?, ?> child;
    protected final RS scrollerRenderer;
    protected int dist;
    protected double scrollerY;
    protected int scrollerHeight;
    protected int travel;
    protected int topOffset;
    protected int scrollerPadding;
    protected boolean keepSpaceForScrollbar = true;
    List<LayoutComponent<?, ?>> children = List.of();
    private boolean mouseDown = false;
    private int mouseDownY = 0;
    private int scrollerDownY = 0;
    GuiEventListener focused;
    boolean dragging;

    public VerticalScroll(Value width, Value height, RS scrollerRenderer) {
        super(width, height, new NullRenderer());
        this.scrollerRenderer = scrollerRenderer;
        this.scrollerPadding = scrollerRenderer.scrollerPadding();
    }

    public static VerticalScroll<VanillaScrollerRenderer> create(LayoutComponent<?, ?> c) {
        return VerticalScroll.create(Value.relative(1.0), Value.relative(1.0), c);
    }

    public static VerticalScroll<VanillaScrollerRenderer> create(Value width, Value height, LayoutComponent<?, ?> c) {
        VerticalScroll<VanillaScrollerRenderer> res = new VerticalScroll<VanillaScrollerRenderer>(width, height, VanillaScrollerRenderer.DEFAULT);
        res.setChild(c);
        return res;
    }

    public VerticalScroll<RS> setChild(LayoutComponent<?, ?> c) {
        this.child = c;
        this.children = List.of(this.child);
        return this;
    }

    public VerticalScroll<RS> setScrollerPadding(int pad) {
        this.scrollerPadding = pad;
        return this;
    }

    public VerticalScroll<RS> setKeepSpaceForScrollbar(boolean value) {
        this.keepSpaceForScrollbar = value;
        return this;
    }

    @Override
    protected int updateContainerWidth(int containerWidth) {
        int myWidth = this.width.calculateOrFill(containerWidth);
        if (this.child != null) {
            this.child.width.calculateOrFill(myWidth - this.scrollerWidth());
            this.child.updateContainerWidth(this.child.width.calculatedSize());
        }
        return myWidth;
    }

    @Override
    protected int updateContainerHeight(int containerHeight) {
        int myHeight = this.height.calculateOrFill(containerHeight);
        if (this.child != null) {
            this.child.height.calculateOrFill(myHeight);
            this.child.updateContainerHeight(this.child.height.calculatedSize());
        }
        return myHeight;
    }

    protected int scrollerWidth() {
        return this.scrollerRenderer.scrollerWidth() + this.scrollerPadding;
    }

    @Override
    public int getContentWidth() {
        return this.scrollerWidth() + (this.child != null ? this.child.getContentWidth() : 0);
    }

    @Override
    public int getContentHeight() {
        return this.child != null ? this.child.getContentHeight() : 0;
    }

    @Override
    void setRelativeBounds(int left, int top) {
        super.setRelativeBounds(left, top);
        if (this.child != null) {
            boolean willNeedScrollBar;
            int width = this.relativeBounds.width;
            boolean bl = willNeedScrollBar = this.keepSpaceForScrollbar || this.child.height.calculatedSize() > this.relativeBounds.height;
            if (willNeedScrollBar) {
                width -= this.scrollerWidth();
            }
            int childLeft = width - this.child.width.calculatedSize();
            if (this.child.hAlign == Alignment.MIN) {
                childLeft = 0;
            } else if (this.child.hAlign == Alignment.CENTER) {
                childLeft /= 2;
            }
            int childTop = this.relativeBounds.height - this.child.height.calculatedSize();
            if (this.child.vAlign == Alignment.MIN) {
                childTop = 0;
            } else if (this.child.vAlign == Alignment.CENTER) {
                childTop /= 2;
            }
            this.child.setRelativeBounds(childLeft, childTop);
        }
        this.updateScrollViewMetrics();
    }

    @Override
    public void updateScreenBounds(Panel parentpanel, int worldX, int worldY) {
        super.updateScreenBounds(parentpanel, worldX, worldY);
        if (this.child != null) {
            this.child.updateScreenBounds(parentpanel, this.screenBounds.left, this.screenBounds.top);
        }
    }

    @Override
    protected void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle renderBounds, Rectangle clipRect) {
        super.renderInBounds(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
        if (this.showScrollBar()) {
            if (this.child != null) {
                guiGraphics.pose().translate(0.0f, (float)this.scrollerOffset(), 0.0f);
                this.setClippingRect(guiGraphics, clipRect);
                this.child.render(guiGraphics, mouseX, mouseY - this.scrollerOffset(), deltaTicks, renderBounds.movedBy(0, this.scrollerOffset(), this.scrollerWidth(), 0), clipRect);
                this.setClippingRect(guiGraphics, null);
                guiGraphics.pose().translate(0.0f, (float)(-this.scrollerOffset()), 0.0f);
            }
            this.scrollerRenderer.renderScrollBar(guiGraphics, renderBounds, this.saveScrollerY(), this.scrollerHeight, this.getZIndex());
        } else if (this.child != null) {
            this.child.render(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
        }
    }

    protected void updateScrollViewMetrics() {
        int view = this.relativeBounds.height;
        int content = this.child.relativeBounds.height;
        this.dist = content - view;
        this.scrollerHeight = Math.max(this.scrollerRenderer.scrollerHeight(), view * view / content);
        this.travel = view - this.scrollerHeight;
        this.topOffset = 0;
        this.scrollerY = 0.0;
    }

    protected int saveScrollerY() {
        return (int)Math.max(0.0, Math.min((double)this.travel, this.scrollerY));
    }

    protected int scrollerOffset() {
        return -((int)((float)this.saveScrollerY() / (float)this.travel * (float)this.dist));
    }

    public boolean showScrollBar() {
        return this.child != null && this.child.relativeBounds.height > this.relativeBounds.height;
    }

    public void mouseMoved(double x, double y) {
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            super.mouseMoved(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset());
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean mouseClicked(double x, double y, int button) {
        Rectangle scroller = this.scrollerRenderer.getScrollerBounds(this.relativeBounds);
        Rectangle picker = this.scrollerRenderer.getPickerBounds(scroller, this.saveScrollerY(), this.scrollerHeight);
        if (picker.contains((int)x, (int)y)) {
            this.mouseDown = true;
            this.mouseDownY = (int)y;
            this.scrollerDownY = this.saveScrollerY();
            return true;
        }
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            return super.mouseClicked(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), button);
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.mouseDown = false;
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            return super.mouseReleased(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), button);
        }
        return false;
    }

    public boolean mouseDragged(double x, double y, int button, double x2, double y2) {
        if (this.mouseDown) {
            int delta = (int)y - this.mouseDownY;
            this.scrollerY = this.scrollerDownY + delta;
            return true;
        }
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            return super.mouseDragged(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), button, x2, y2);
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double deltaX, double deltaY) {
        boolean didCapture = false;
        if (this.child != null && this.relativeBounds.contains(x, y)) {
            didCapture = super.mouseScrolled(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset(), deltaX, deltaY);
        }
        if (!didCapture) {
            this.scrollerY = Math.max(0.0, Math.min((double)this.travel, this.scrollerY)) - deltaY;
            return true;
        }
        return false;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        this.focused = guiEventListener;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean bl) {
        this.dragging = bl;
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        if (this.child != null && this.child.isMouseOver(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top - (double)this.scrollerOffset())) {
            return true;
        }
        return this.relativeBounds.contains(x, y);
    }
}

