/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.SulphurCrystalBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.Nullable;

public class BrimstoneBlock
extends BaseBlock.Stone {
    public static final BooleanProperty ACTIVATED = BlockProperties.ACTIVE;

    public BrimstoneBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE).mapColor(MapColor.COLOR_BROWN).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{ACTIVATED});
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.isClientSide()) {
            this.updateChunks((ClientLevel)world, pos);
        }
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            this.updateChunks((ClientLevel)world, pos);
        }
    }

    private void updateChunks(ClientLevel world, BlockPos pos) {
        int y = pos.getY() >> 4;
        int x1 = pos.getX() - 2 >> 4;
        int z1 = pos.getZ() - 2 >> 4;
        int x2 = pos.getX() + 2 >> 4;
        int z2 = pos.getZ() + 2 >> 4;
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                world.setSectionDirtyWithNeighbors(x, y, z);
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        boolean deactivate = true;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.getFluidState(pos.relative(dir)).getType().equals(Fluids.WATER)) continue;
            deactivate = false;
            break;
        }
        if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            if (deactivate) {
                world.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            } else if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && random.nextInt(16) == 0) {
                Direction dir = BlocksHelper.randomDirection((RandomSource)random);
                BlockPos side = pos.relative(dir);
                BlockState sideState = world.getBlockState(side);
                if (sideState.getBlock() instanceof SulphurCrystalBlock) {
                    if ((Integer)sideState.getValue((Property)SulphurCrystalBlock.AGE) < 2 && ((Boolean)sideState.getValue((Property)SulphurCrystalBlock.WATERLOGGED)).booleanValue()) {
                        int age = (Integer)sideState.getValue((Property)SulphurCrystalBlock.AGE) + 1;
                        world.setBlockAndUpdate(side, (BlockState)sideState.setValue((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(age)));
                    }
                } else if (sideState.getFluidState().getType() == Fluids.WATER) {
                    BlockState crystal = (BlockState)((BlockState)((BlockState)EndBlocks.SULPHUR_CRYSTAL.defaultBlockState().setValue((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).setValue((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(0));
                    world.setBlockAndUpdate(side, crystal);
                }
            }
        } else if (!deactivate && !((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        }
    }
}

