/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.client.models.EndModels;

public abstract class EndPedestal
extends PedestalBlock {
    protected EndPedestal(Block parent) {
        super(parent);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected TextureMapping createTextureMapping() {
        ResourceLocation parentTexture = BetterEnd.C.convertNamespace(TextureMapping.getBlockTexture((Block)this.parent));
        ResourceLocation polishedTexture = BetterEnd.C.convertNamespace(TextureMapping.getBlockTexture((Block)this.parent, (String)"_polished"));
        return new TextureMapping().put(TextureSlot.TOP, polishedTexture).put(TextureSlot.BOTTOM, polishedTexture).put(EndModels.BASE, polishedTexture).put(EndModels.PILLAR, parentTexture.withSuffix("_pillar_side"));
    }

    public static class Metal
    extends EndPedestal
    implements BehaviourMetal {
        public Metal(Block parent) {
            super(parent);
        }
    }

    public static class Wood
    extends EndPedestal
    implements BehaviourWood {
        public Wood(Block parent) {
            super(parent);
        }
    }

    public static class Stone
    extends EndPedestal
    implements BehaviourStone {
        public Stone(Block parent) {
            super(parent);
        }
    }
}

