/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.portal.PortalBuilder;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndPortals;

public class EndPortalBlock
extends NetherPortalBlock
implements RenderLayerProvider,
CustomColorProvider,
Portal {
    public static final IntegerProperty PORTAL = EndBlockProperties.PORTAL;

    public EndPortalBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_PORTAL).destroyTime(Blocks.BEDROCK.getExplosionResistance()).lightLevel(bs -> 15));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PORTAL});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        double x = (double)pos.getX() + random.nextDouble();
        double y = (double)pos.getY() + random.nextDouble();
        double z = (double)pos.getZ() + random.nextDouble();
        int k = random.nextInt(2) * 2 - 1;
        if (!world.getBlockState(pos.west()).is((Block)this) && !world.getBlockState(pos.east()).is((Block)this)) {
            x = (double)pos.getX() + 0.5 + 0.25 * (double)k;
        } else {
            z = (double)pos.getZ() + 0.5 + 0.25 * (double)k;
        }
        world.addParticle((ParticleOptions)EndParticles.PORTAL_SPHERE, x, y, z, 0.0, 0.0, 0.0);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        return state;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this.validate(entity)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    private boolean validate(Entity entity) {
        return !entity.isPassenger() && !entity.isVehicle() && entity.canUsePortal(false);
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    public BlockColor getProvider() {
        return (state, world, pos, tintIndex) -> EndPortals.getColor((Integer)state.getValue((Property)PORTAL));
    }

    public ItemColor getItemProvider() {
        return (stack, tintIndex) -> EndPortals.getColor(0);
    }

    public DimensionTransition getPortalDestination(ServerLevel serverLevel, Entity entity, BlockPos blockPos) {
        ResourceKey destination = serverLevel.dimension() == Level.END ? Level.OVERWORLD : Level.END;
        ServerLevel destinationLevel = serverLevel.getServer().getLevel(destination);
        if (destinationLevel == null) {
            return null;
        }
        WorldBorder worldBorder = destinationLevel.getWorldBorder();
        double d = DimensionType.getTeleportationScale((DimensionType)serverLevel.dimensionType(), (DimensionType)destinationLevel.dimensionType());
        BlockPos startPos = worldBorder.clampToBounds(entity.getX() * d, entity.getY(), entity.getZ() * d);
        return this.getExitPortal(serverLevel, destinationLevel, entity, blockPos, startPos, worldBorder);
    }

    private DimensionTransition getExitPortal(ServerLevel sourceLevel, ServerLevel destinationLevel, Entity entity, BlockPos pos, BlockPos startPos, WorldBorder worldBorder) {
        PortalBuilder builder = new PortalBuilder((Level)sourceLevel, destinationLevel);
        Optional<PortalBuilder.FoundPortalRect> portalRectangle = builder.findPortalAround(startPos, worldBorder);
        if (portalRectangle.isPresent()) {
            BlockUtil.FoundRectangle foundRectangle = portalRectangle.get().rect();
            DimensionTransition.PostDimensionTransition postDimensionTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(x -> {
                x.placePortalTicket(((PortalBuilder.FoundPortalRect)portalRectangle.get()).pos());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entity;
                    BECriteria.PORTAL_TRAVEL.trigger(sp);
                }
            });
            return EndPortalBlock.getDimensionTransitionFromExit(entity, destinationLevel, pos, foundRectangle, postDimensionTransition);
        }
        BetterEnd.C.LOG.error("Unable to find portal exit.");
        return null;
    }

    private static DimensionTransition getDimensionTransitionFromExit(Entity entity, ServerLevel destinationLevel, BlockPos portalEntrancePos, BlockUtil.FoundRectangle foundRectangle, DimensionTransition.PostDimensionTransition postDimensionTransition) {
        Vec3 exitPos;
        Direction.Axis portalAxis;
        BlockState blockState = entity.level().getBlockState(portalEntrancePos);
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            portalAxis = (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle exitZone = BlockUtil.getLargestRectangleAround((BlockPos)portalEntrancePos, (Direction.Axis)portalAxis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p -> entity.level().getBlockState(p) == blockState);
            exitPos = entity.getRelativePortalPosition(portalAxis, exitZone);
        } else {
            portalAxis = Direction.Axis.X;
            exitPos = new Vec3(0.5, 0.0, 0.0);
        }
        return EndPortalBlock.createDimensionTransition(destinationLevel, entity, entity.getDeltaMovement(), foundRectangle, portalAxis, exitPos, entity.getYRot(), entity.getXRot(), postDimensionTransition);
    }

    private static DimensionTransition createDimensionTransition(ServerLevel destinationLevel, Entity entity, Vec3 entityMovementDirection, BlockUtil.FoundRectangle foundRectangle, Direction.Axis portalAxis, Vec3 exitPos, float yRot, float xRot, DimensionTransition.PostDimensionTransition postDimensionTransition) {
        BlockPos portalBasePos = foundRectangle.minCorner;
        BlockState exitPortalState = destinationLevel.getBlockState(portalBasePos);
        Direction.Axis destinationAxis = exitPortalState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        int rotationOffset = portalAxis == destinationAxis ? 0 : 90;
        Vec3 exitMovementDirection = portalAxis == destinationAxis ? entityMovementDirection : new Vec3(entityMovementDirection.z, entityMovementDirection.y, -entityMovementDirection.x);
        double relX = (double)entityDimensions.width() / 2.0 + (double)((float)foundRectangle.axis1Size - entityDimensions.width()) * exitPos.x();
        double relZ = 0.5 + exitPos.z();
        boolean exitInX = destinationAxis == Direction.Axis.X;
        Vec3 teleportPosition = PortalShape.findCollisionFreePosition((Vec3)new Vec3((double)portalBasePos.getX() + (exitInX ? relX : relZ), (double)portalBasePos.getY() + (double)((float)foundRectangle.axis2Size - entityDimensions.height()) * exitPos.y(), (double)portalBasePos.getZ() + (exitInX ? relZ : relX)), (ServerLevel)destinationLevel, (Entity)entity, (EntityDimensions)entityDimensions);
        return new DimensionTransition(destinationLevel, teleportPosition, exitMovementDirection, yRot + (float)rotationOffset, xRot, postDimensionTransition);
    }
}

