/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.GlowingHymenophoreBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public class GlowingPillarLuminophorBlock
extends BaseBlock
implements AddMineableShears,
BlockModelProvider {
    public static final BooleanProperty NATURAL = EndBlockProperties.NATURAL;

    public GlowingPillarLuminophorBlock() {
        super(BehaviourBuilders.createMetal((MapColor)MapColor.COLOR_ORANGE).strength(0.2f).lightLevel(bs -> 15).sound(SoundType.GRASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return (Boolean)state.getValue((Property)NATURAL) == false || world.getBlockState(pos.below()).is(EndBlocks.GLOWING_PILLAR_ROOTS);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{NATURAL});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        GlowingHymenophoreBlock.provideUnshadedCubeModel(generator, (Block)this);
    }
}

