/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlant;
import org.betterx.bclib.blocks.UnderwaterPlantBlock;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class HydraluxBlock
extends UnderwaterPlantBlock
implements BehaviourWaterPlant,
AddMineableShears {
    public static final EnumProperty<EndBlockProperties.HydraluxShape> SHAPE = EndBlockProperties.HYDRALUX_SHAPE;

    public HydraluxBlock() {
        super(BehaviourBuilders.createWaterPlant().lightLevel(state -> ((EndBlockProperties.HydraluxShape)((Object)((Object)state.getValue(SHAPE)))).hasGlow() ? 15 : 0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState down = world.getBlockState(pos.below());
        EndBlockProperties.HydraluxShape shape = (EndBlockProperties.HydraluxShape)((Object)state.getValue(SHAPE));
        if (shape == EndBlockProperties.HydraluxShape.FLOWER_BIG_TOP || shape == EndBlockProperties.HydraluxShape.FLOWER_SMALL_TOP) {
            return down.is((Block)this);
        }
        if (shape == EndBlockProperties.HydraluxShape.ROOTS) {
            return down.is(EndBlocks.SULPHURIC_ROCK.stone) && world.getBlockState(pos.above()).is((Block)this);
        }
        return down.is((Block)this) && world.getBlockState(pos.above()).is((Block)this);
    }

    protected boolean isTerrain(BlockState state) {
        return state.is(CommonBlockTags.END_STONES);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)EndBlocks.HYDRALUX_SAPLING);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        EndBlockProperties.HydraluxShape shape = (EndBlockProperties.HydraluxShape)((Object)state.getValue(SHAPE));
        if (shape == EndBlockProperties.HydraluxShape.FLOWER_BIG_BOTTOM || shape == EndBlockProperties.HydraluxShape.FLOWER_SMALL_BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)EndItems.HYDRALUX_PETAL, MHelper.randRange((int)1, (int)4, (RandomSource)MHelper.RANDOM_SOURCE))});
        }
        if (shape == EndBlockProperties.HydraluxShape.ROOTS) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)EndBlocks.HYDRALUX_SAPLING, MHelper.randRange((int)1, (int)2, (RandomSource)MHelper.RANDOM_SOURCE))});
        }
        return Collections.emptyList();
    }
}

