/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.betterend.blocks.basis.EndPlantBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnEndBone;
import org.betterx.wover.block.api.BlockProperties;

public class LargeAmaranitaBlock
extends EndPlantBlock
implements BehaviourPlant,
SurvivesOnEndBone {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private static final VoxelShape SHAPE_TOP = Shapes.or((VoxelShape)Block.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)SHAPE_BOTTOM);

    public LargeAmaranitaBlock() {
        super(BehaviourBuilders.createWalkablePlant((MapColor)MapColor.COLOR_RED).ignitedByLava().lightLevel(state -> state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? 15 : 0));
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.getValue(SHAPE);
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return this.isTerrain(world.getBlockState(pos.below())) && world.getBlockState(pos.above()).is((Block)this);
        }
        if (shape == BlockProperties.TripleShape.TOP) {
            return world.getBlockState(pos.below()).is((Block)this);
        }
        return world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.above()).is((Block)this);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnEndBone.super.isTerrain(state);
    }
}

