/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.entity.SilkMothEntity;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndItems;

public class SilkMothNestBlock
extends BaseBlock
implements RenderLayerProvider,
AddMineableShears {
    public static final BooleanProperty ACTIVE = EndBlockProperties.ACTIVE;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty FULLNESS = EndBlockProperties.FULLNESS;
    private static final VoxelShape TOP = SilkMothNestBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape BOTTOM = SilkMothNestBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SilkMothNestBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).strength(0.5f, 0.1f).sound(SoundType.WOOL).noOcclusion().randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)FULLNESS, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{ACTIVE, FACING, FULLNESS});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? BOTTOM : TOP;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = ctx.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            if (SilkMothNestBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN) || world.getBlockState(pos.above()).is(BlockTags.LEAVES)) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal((BlockState)state, (Rotation)rotation, (Property)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal((BlockState)state, (Mirror)mirror, (Property)FACING);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? Collections.singletonList(new ItemStack((ItemLike)this)) : Collections.emptyList();
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState up;
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && player.isCreative()) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.below(), (Block)Blocks.AIR);
        }
        if ((up = world.getBlockState(pos.above())).is((Block)this) && !((Boolean)up.getValue((Property)ACTIVE)).booleanValue()) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.above(), (Block)Blocks.AIR);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            return;
        }
        if (random.nextBoolean()) {
            return;
        }
        Direction dir = (Direction)state.getValue((Property)FACING);
        BlockPos spawn = pos.relative(dir);
        if (!world.getBlockState(spawn).isAir()) {
            return;
        }
        int count = world.getEntities((EntityTypeTest)EndEntities.SILK_MOTH.type(), new AABB(pos).inflate(16.0), entity -> true).size();
        if (count > 6) {
            return;
        }
        SilkMothEntity moth = new SilkMothEntity((EntityType<? extends SilkMothEntity>)EndEntities.SILK_MOTH.type(), (Level)world);
        moth.moveTo((double)spawn.getX() + 0.5, (double)spawn.getY() + 0.5, (double)spawn.getZ() + 0.5, dir.toYRot(), 0.0f);
        moth.setDeltaMovement(new Vec3((double)dir.getStepX() * 0.4, 0.0, (double)dir.getStepZ() * 0.4));
        moth.setHive((Level)world, pos);
        world.addFreshEntity((Entity)moth);
        world.playSound(null, pos, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.MAIN_HAND && BaseShearsItem.isShear((ItemStack)stack) && ((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && (Integer)state.getValue((Property)FULLNESS) == 3) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)FULLNESS, (Comparable)Integer.valueOf(0))));
            Direction dir = (Direction)state.getValue((Property)FACING);
            double px = (double)(pos.getX() + dir.getStepX()) + 0.5;
            double py = (double)(pos.getY() + dir.getStepY()) + 0.5;
            double pz = (double)(pos.getZ() + dir.getStepZ()) + 0.5;
            ItemStack drop = new ItemStack((ItemLike)EndItems.SILK_FIBER, MHelper.randRange((int)1, (int)4, (RandomSource)world.getRandom()));
            ItemEntity entity = new ItemEntity(world, px, py, pz, drop);
            world.addFreshEntity((Entity)entity);
            drop = new ItemStack((ItemLike)EndItems.SILK_MOTH_MATRIX, MHelper.randRange((int)1, (int)3, (RandomSource)world.getRandom()));
            entity = new ItemEntity(world, px, py, pz, drop);
            world.addFreshEntity((Entity)entity);
            if (!player.isCreative()) {
                stack.setDamageValue(stack.getDamageValue() + 1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

