/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.basis.EndPlantBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnEndBone;
import org.betterx.betterend.registry.features.EndConfiguredVegetation;

public class SmallAmaranitaBlock
extends EndPlantBlock
implements SurvivesOnEndBone,
BehaviourPlant {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public SmallAmaranitaBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.COLOR_RED).offsetType(BlockBehaviour.OffsetType.XZ));
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos bigPos = this.growBig(world, pos);
        if (bigPos != null && EndConfiguredVegetation.GIGANTIC_AMARANITA.placeInWorld((WorldGenLevel)world, pos, random)) {
            this.replaceMushroom(world, bigPos);
            this.replaceMushroom(world, bigPos.south());
            this.replaceMushroom(world, bigPos.east());
            this.replaceMushroom(world, bigPos.south().east());
            return;
        }
        EndConfiguredVegetation.LARGE_AMARANITA.placeInWorld((WorldGenLevel)world, pos, random);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.getOffset(view, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    private BlockPos growBig(ServerLevel world, BlockPos pos) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos p = pos.offset(x, 0, z);
                if (!this.checkFrame(world, p)) continue;
                return p;
            }
        }
        return null;
    }

    private boolean checkFrame(ServerLevel world, BlockPos pos) {
        return world.getBlockState(pos).is((Block)this) && world.getBlockState(pos.south()).is((Block)this) && world.getBlockState(pos.east()).is((Block)this) && world.getBlockState(pos.south().east()).is((Block)this);
    }

    private void replaceMushroom(ServerLevel world, BlockPos pos) {
        if (world.getBlockState(pos).is((Block)this)) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (Block)Blocks.AIR);
        }
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(8) == 0;
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnEndBone.super.isTerrain(state);
    }
}

