/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VentBubbleColumnBlock
extends Block
implements BucketPickup,
LiquidBlockContainer {
    public VentBubbleColumnBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BUBBLE_COLUMN).noOcclusion().noCollission().noLootTable());
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack((ItemLike)Items.WATER_BUCKET);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.below());
        return blockState.is((Block)this) || blockState.is(EndBlocks.HYDROTHERMAL_VENT);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.WATER.defaultBlockState();
        }
        BlockPos up = pos.above();
        if (world.getBlockState(up).is(Blocks.WATER)) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)up, (Block)this);
            world.scheduleTick(up, (Block)this, 5);
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(4) == 0) {
            double px = (double)pos.getX() + random.nextDouble();
            double py = (double)pos.getY() + random.nextDouble();
            double pz = (double)pos.getZ() + random.nextDouble();
            world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, px, py, pz, 0.0, 0.04, 0.0);
        }
        if (random.nextInt(200) == 0) {
            world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState blockState = world.getBlockState(pos.above());
        if (blockState.isAir()) {
            entity.onAboveBubbleCol(false);
            if (!world.isClientSide) {
                ServerLevel serverWorld = (ServerLevel)world;
                for (int i = 0; i < 2; ++i) {
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + world.random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            entity.onInsideBubbleColumn(false);
        }
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return Fluids.WATER.getSource(false);
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

