/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.gui;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.BlastingRecipeBookComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.betterend.blocks.entities.EndStoneSmelterBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class EndStoneSmelterRecipeBookScreen
extends BlastingRecipeBookComponent {
    private Ingredient fuels;
    private Slot fuelSlot;

    protected Set<Item> getFuelItems() {
        return EndStoneSmelterBlockEntity.availableFuels().keySet();
    }

    public void slotClicked(Slot slot) {
        super.slotClicked(slot);
        if (slot != null && slot.index < this.menu.getSize()) {
            this.fuelSlot = null;
        }
    }

    public void setupGhostRecipe(RecipeHolder<?> recipe, List<Slot> slots) {
        this.ghostRecipe.clear();
        ItemStack result = recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        this.ghostRecipe.setRecipe(recipe);
        this.ghostRecipe.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{result}), slots.get((int)3).x, slots.get((int)3).y);
        NonNullList inputs = recipe.value().getIngredients();
        this.fuelSlot = slots.get(2);
        if (this.fuelSlot.getItem().isEmpty()) {
            if (this.fuels == null) {
                this.fuels = Ingredient.of(this.getFuelItems().stream().map(ItemStack::new));
            }
            this.ghostRecipe.addIngredient(this.fuels, this.fuelSlot.x, this.fuelSlot.y);
        }
        Iterator iterator = inputs.iterator();
        for (int i = 0; i < 2; ++i) {
            if (!iterator.hasNext()) {
                return;
            }
            Ingredient ingredient = (Ingredient)iterator.next();
            if (ingredient.isEmpty()) continue;
            Slot slot = slots.get(i);
            this.ghostRecipe.addIngredient(ingredient, slot.x, slot.y);
        }
    }
}

