/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.client.gui.EndStoneSmelterMenu;
import org.betterx.betterend.client.gui.EndStoneSmelterRecipeBookScreen;

@OnlyIn(value=Dist.CLIENT)
public class EndStoneSmelterScreen
extends AbstractContainerScreen<EndStoneSmelterMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation BACKGROUND_TEXTURE = BetterEnd.C.mk("textures/gui/smelter_gui.png");
    public final EndStoneSmelterRecipeBookScreen recipeBook = new EndStoneSmelterRecipeBookScreen();
    private boolean narrow;

    public EndStoneSmelterScreen(EndStoneSmelterMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    public void init() {
        super.init();
        this.narrow = this.width < 379;
        this.recipeBook.init(this.width, this.height, this.minecraft, this.narrow, (RecipeBookMenu)this.menu);
        this.leftPos = this.recipeBook.updateScreenPosition(this.width, this.imageWidth);
        ImageButton button = new ImageButton(this.leftPos + 20, this.height / 2 - 49, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, buttonWidget -> {
            this.recipeBook.initVisuals();
            this.recipeBook.toggleVisibility();
            this.leftPos = this.recipeBook.updateScreenPosition(this.width, this.imageWidth);
            buttonWidget.setPosition(this.leftPos + 20, this.height / 2 - 49);
        });
        this.addRenderableWidget((GuiEventListener)button);
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void containerTick() {
        super.containerTick();
        this.recipeBook.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        if (this.recipeBook.isVisible() && this.narrow) {
            this.renderBg(guiGraphics, delta, mouseX, mouseY);
            this.recipeBook.render(guiGraphics, mouseX, mouseY, delta);
        } else {
            this.recipeBook.render(guiGraphics, mouseX, mouseY, delta);
            super.render(guiGraphics, mouseX, mouseY, delta);
            this.recipeBook.renderGhostRecipe(guiGraphics, this.leftPos, this.topPos, true, delta);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.recipeBook.renderTooltip(guiGraphics, this.leftPos, this.topPos, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.recipeBook.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.narrow && this.recipeBook.isVisible() || super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int invSlot, int clickData, ClickType actionType) {
        super.slotClicked(slot, invSlot, clickData, actionType);
        this.recipeBook.slotClicked(slot);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return !this.recipeBook.keyPressed(keyCode, scanCode, modifiers) && super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        boolean isMouseOut = mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.imageWidth) || mouseY >= (double)(top + this.imageHeight);
        return this.recipeBook.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, button) && isMouseOut;
    }

    public boolean charTyped(char chr, int keyCode) {
        return this.recipeBook.charTyped(chr, keyCode) || super.charTyped(chr, keyCode);
    }

    public void recipesUpdated() {
        this.recipeBook.recipesUpdated();
    }

    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBook;
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        int progress;
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((EndStoneSmelterMenu)this.menu).isBurning()) {
            progress = ((EndStoneSmelterMenu)this.menu).getFuelProgress();
            guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos + 56, this.topPos + 36 + 12 - progress, 176, 12 - progress, 14, progress + 1);
        }
        progress = ((EndStoneSmelterMenu)this.menu).getSmeltProgress();
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos + 92, this.topPos + 34, 176, 14, progress + 1, 16);
    }
}

