/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.enchantment.api.EnchantmentUtils;
import org.jetbrains.annotations.Nullable;

public class SilkMothEntity
extends Animal
implements FlyingAnimal {
    private BlockPos hivePos;
    private BlockPos entrance;
    private Level hiveWorld;

    public SilkMothEntity(EntityType<? extends SilkMothEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new MothLookControl(this, (Mob)this);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.xpReward = 1;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.FLYING_SPEED, 0.4).add(Attributes.MOVEMENT_SPEED, 0.1);
    }

    public void setHive(Level world, BlockPos hive) {
        this.hivePos = hive;
        this.hiveWorld = world;
    }

    public boolean canBeLeashed() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.hivePos != null) {
            tag.put("HivePos", NbtUtils.writeBlockPos((BlockPos)this.hivePos));
            tag.putString("HiveWorld", this.hiveWorld.dimension().location().toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("HivePos")) {
            this.hivePos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"HivePos").orElse(BlockPos.ZERO);
            ResourceLocation worldID = ResourceLocation.parse((String)tag.getString("HiveWorld"));
            try {
                this.hiveWorld = this.level().getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)worldID));
            }
            catch (Exception e) {
                BetterEnd.LOGGER.warn("Silk Moth Hive World {} is missing!", new Object[]{worldID});
                this.hivePos = null;
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ReturnToHiveGoal());
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{EndItems.BLOSSOM_BERRY}), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(8, (Goal)new WanderAroundGoal());
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                BlockState state = this.level.getBlockState(pos);
                return state.isAir() || !state.blocksMotion();
            }

            public void tick() {
                super.tick();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    public boolean isPushable() {
        return true;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean isNoGravity() {
        return true;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)EndEntities.SILK_MOTH.type().create((Level)world);
    }

    protected void dropFromLootTable(DamageSource source, boolean causedByPlayer) {
        int minCount = 0;
        int maxCount = 1;
        if (causedByPlayer && this.lastHurtByPlayer != null) {
            int looting = EnchantmentUtils.getItemEnchantmentLevel((Level)this.lastHurtByPlayer.level(), (ResourceKey)Enchantments.LOOTING, (LivingEntity)this.lastHurtByPlayer);
            minCount += looting;
            if ((maxCount += looting) > 2) {
                maxCount = 2;
            }
        }
        int count = minCount < maxCount ? MHelper.randRange((int)minCount, (int)maxCount, (RandomSource)this.random) : maxCount;
        ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)EndItems.SILK_FIBER, count));
        this.level().addFreshEntity((Entity)drop);
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(EndItems.BLOSSOM_BERRY);
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        return super.mobInteract(player, interactionHand);
    }

    class MothLookControl
    extends LookControl {
        MothLookControl(SilkMothEntity this$0, Mob entity) {
            super(entity);
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }

    class ReturnToHiveGoal
    extends Goal {
        ReturnToHiveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return SilkMothEntity.this.hivePos != null && SilkMothEntity.this.hiveWorld == SilkMothEntity.this.level() && SilkMothEntity.this.navigation.isDone() && SilkMothEntity.this.random.nextInt(8) == 0 && SilkMothEntity.this.position().distanceToSqr((double)SilkMothEntity.this.hivePos.getX(), (double)SilkMothEntity.this.hivePos.getY(), (double)SilkMothEntity.this.hivePos.getZ()) < 16384.0;
        }

        public boolean canContinueToUse() {
            return SilkMothEntity.this.navigation.isInProgress() && SilkMothEntity.this.level().getBlockState(SilkMothEntity.this.entrance).isAir() && (SilkMothEntity.this.level().getBlockState(SilkMothEntity.this.hivePos).is(EndBlocks.SILK_MOTH_NEST) || SilkMothEntity.this.level().getBlockState(SilkMothEntity.this.hivePos).is(EndBlocks.SILK_MOTH_HIVE));
        }

        public void start() {
            BlockState state = SilkMothEntity.this.level().getBlockState(SilkMothEntity.this.hivePos);
            if (!state.is(EndBlocks.SILK_MOTH_NEST) && !state.is(EndBlocks.SILK_MOTH_HIVE)) {
                SilkMothEntity.this.hivePos = null;
                return;
            }
            try {
                SilkMothEntity.this.entrance = SilkMothEntity.this.hivePos.relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
                SilkMothEntity.this.navigation.moveTo(SilkMothEntity.this.navigation.createPath(SilkMothEntity.this.entrance, 1), 1.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void tick() {
            double dz;
            double dy;
            super.tick();
            if (SilkMothEntity.this.entrance == null) {
                return;
            }
            double dx = Math.abs((double)SilkMothEntity.this.entrance.getX() - SilkMothEntity.this.getX());
            if (dx + (dy = Math.abs((double)SilkMothEntity.this.entrance.getY() - SilkMothEntity.this.getY())) + (dz = Math.abs((double)SilkMothEntity.this.entrance.getZ() - SilkMothEntity.this.getZ())) < 1.0) {
                BlockState state = SilkMothEntity.this.level().getBlockState(SilkMothEntity.this.hivePos);
                if (state.is(EndBlocks.SILK_MOTH_NEST) || state.is(EndBlocks.SILK_MOTH_HIVE)) {
                    int fullness = (Integer)state.getValue((Property)EndBlockProperties.FULLNESS);
                    boolean isHive = state.is(EndBlocks.SILK_MOTH_HIVE);
                    if (fullness < 3 && (isHive || SilkMothEntity.this.random.nextBoolean())) {
                        if ((fullness += isHive ? MHelper.randRange((int)1, (int)2, (RandomSource)SilkMothEntity.this.random) : 1) > 3) {
                            fullness = 3;
                        }
                        BlocksHelper.setWithUpdate((LevelAccessor)SilkMothEntity.this.hiveWorld, (BlockPos)SilkMothEntity.this.hivePos, (BlockState)((BlockState)state.setValue((Property)EndBlockProperties.FULLNESS, (Comparable)Integer.valueOf(fullness))));
                    }
                    SilkMothEntity.this.level().playSound(null, SilkMothEntity.this.entrance, SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                    SilkMothEntity.this.discard();
                } else {
                    SilkMothEntity.this.hivePos = null;
                }
            }
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return SilkMothEntity.this.navigation.isDone() && SilkMothEntity.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return SilkMothEntity.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3d = null;
            if (SilkMothEntity.this.hivePos != null && SilkMothEntity.this.hiveWorld == SilkMothEntity.this.level() && SilkMothEntity.this.position().distanceToSqr((double)SilkMothEntity.this.hivePos.getX(), (double)SilkMothEntity.this.hivePos.getY(), (double)SilkMothEntity.this.hivePos.getZ()) > 16.0) {
                vec3d = SilkMothEntity.this.position().add(SilkMothEntity.this.random.nextGaussian() * 2.0, 0.0, SilkMothEntity.this.random.nextGaussian() * 2.0);
            }
            Vec3 vec3 = vec3d = vec3d == null ? this.getRandomLocation() : vec3d;
            if (vec3d != null) {
                try {
                    SilkMothEntity.this.navigation.moveTo(SilkMothEntity.this.navigation.createPath(new BlockPos((int)vec3d.x, (int)vec3d.y, (int)vec3d.z), 1), 1.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d3 = SilkMothEntity.this.getViewVector(0.0f);
            Vec3 vec3d4 = HoverRandomPos.getPos((PathfinderMob)SilkMothEntity.this, (int)8, (int)7, (double)vec3d3.x, (double)vec3d3.z, (float)1.5707964f, (int)3, (int)1);
            return vec3d4 != null ? vec3d4 : AirAndWaterRandomPos.getPos((PathfinderMob)SilkMothEntity.this, (int)8, (int)4, (int)-2, (double)vec3d3.x, (double)vec3d3.z, (double)1.5707963705062866);
        }
    }
}

