/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.byg.biomes;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.integration.byg.biomes.BYGBiomes;
import org.betterx.betterend.integration.byg.features.BYGFeatures;
import org.betterx.betterend.registry.features.EndLakeFeatures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;

public class NightshadeRedwoods
extends EndBiome.Config {
    @Override
    public void addCustomBuildData(EndBiomeBuilder builder) {
        ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)builder.fogColor(140, 108, 47)).fogDensity(1.5f)).waterAndFogColor(55, 70, 186)).foliageColorOverride(122, 17, 155)).particles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, 0.002f)).grassColorOverride(48, 13, 89)).plantsColor(200, 125, 9)).feature((BasePlacedFeatureKey)EndLakeFeatures.END_LAKE_RARE)).feature((BasePlacedFeatureKey)BYGFeatures.NIGHTSHADE_REDWOOD_TREE)).feature((BasePlacedFeatureKey)BYGFeatures.NIGHTSHADE_MOSS_WOOD)).feature((BasePlacedFeatureKey)BYGFeatures.NIGHTSHADE_MOSS);
        Holder biome = Integrations.BYG.getBiome("nightshade_forest");
        if (biome == null) {
            return;
        }
        BiomeSpecialEffects effects = ((Biome)biome.value()).getSpecialEffects();
        if (BCLib.isClient()) {
            Holder loop = (Holder)effects.getAmbientLoopSoundEvent().get();
            Holder music = ((Music)effects.getBackgroundMusic().get()).getEvent();
            Holder additions = ((AmbientAdditionsSettings)effects.getAmbientAdditionsSettings().get()).getSoundEvent();
            Holder mood = ((AmbientMoodSettings)effects.getAmbientMoodSettings().get()).getSoundEvent();
            ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)builder.loop(loop)).music(music)).additions(additions)).mood(mood);
        }
        ((Biome)biome.value()).getGenerationSettings().features().forEach(list -> list.forEach(feature -> builder.feature(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)feature)));
        for (MobCategory group : MobCategory.values()) {
            List list2 = ((Biome)biome.value()).getMobSettings().getMobs(group).unwrap();
            list2.forEach(entry -> builder.spawn(entry.type, 1, entry.minCount, entry.maxCount));
        }
    }

    @Override
    public SurfaceMaterialProvider surfaceMaterial() {
        return new EndBiome.DefaultSurfaceMaterialProvider(this){

            @Override
            public BlockState getTopMaterial() {
                return Integrations.BYG.getBlock("nightshade_phylium").defaultBlockState();
            }

            @Override
            public SurfaceRuleBuilder surface() {
                return (SurfaceRuleBuilder)SurfaceRuleBuilder.start().rule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)BYGBiomes.BYG_WATER_CHECK, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)this.getTopMaterial())))}), 4);
            }
        };
    }
}

