/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.client.render.HumanoidArmorRenderer;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.item.model.CrystaliteBootsModel;
import org.betterx.betterend.item.model.CrystaliteChestplateModel;
import org.betterx.betterend.item.model.CrystaliteHelmetModel;
import org.betterx.betterend.item.model.CrystaliteLeggingsModel;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CrystaliteArmorRenderer
extends HumanoidArmorRenderer {
    private static final ResourceLocation FIRST_LAYER = BetterEnd.C.mk("textures/models/armor/crystalite_layer_1.png");
    private static final ResourceLocation SECOND_LAYER = BetterEnd.C.mk("textures/models/armor/crystalite_layer_2.png");
    private static final CrystaliteHelmetModel HELMET_MODEL = CrystaliteHelmetModel.createModel(null);
    private static final CrystaliteChestplateModel CHEST_MODEL = CrystaliteChestplateModel.createRegularModel(null);
    private static final CrystaliteChestplateModel CHEST_MODEL_SLIM = CrystaliteChestplateModel.createThinModel(null);
    private static final CrystaliteLeggingsModel LEGGINGS_MODEL = CrystaliteLeggingsModel.createModel(null);
    private static final CrystaliteBootsModel BOOTS_MODEL = CrystaliteBootsModel.createModel(null);
    private static CrystaliteArmorRenderer INSTANCE = null;

    public static CrystaliteArmorRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CrystaliteArmorRenderer();
        }
        return INSTANCE;
    }

    public ResourceLocation textureForSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? SECOND_LAYER : FIRST_LAYER;
    }

    public HumanoidModel<LivingEntity> modelFor(LivingEntity entity, EquipmentSlot slot) {
        return this.getModelForSlot(entity, slot);
    }

    @NotNull
    protected ResourceLocation getTextureForSlot(EquipmentSlot slot, boolean innerLayer) {
        return innerLayer ? SECOND_LAYER : FIRST_LAYER;
    }

    protected HumanoidModel<LivingEntity> getModelForSlot(LivingEntity entity, EquipmentSlot slot) {
        if (slot == EquipmentSlot.HEAD) {
            return HELMET_MODEL;
        }
        if (slot == EquipmentSlot.LEGS) {
            return LEGGINGS_MODEL;
        }
        if (slot == EquipmentSlot.FEET) {
            return BOOTS_MODEL;
        }
        if (slot == EquipmentSlot.CHEST) {
            AbstractClientPlayer acp;
            if (entity instanceof AbstractClientPlayer && (acp = (AbstractClientPlayer)entity).getSkin().model().id().equals("slim")) {
                return CHEST_MODEL_SLIM;
            }
            return CHEST_MODEL;
        }
        return null;
    }
}

