/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.util.EndStructureHelper;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.state.api.WorldConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpikeFeature.class})
public class SpikeFeatureMixin {
    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_place(FeaturePlaceContext<SpikeConfiguration> featurePlaceContext, CallbackInfoReturnable<Boolean> info) {
        if (!GeneratorOptions.hasPillars()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"placeSpike"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_placeSpike(ServerLevelAccessor world, RandomSource random, SpikeConfiguration config, SpikeFeature.EndSpike spike, CallbackInfo info) {
        int x = spike.getCenterX();
        int z = spike.getCenterZ();
        int radius = spike.getRadius();
        int minY = 0;
        long lx = x;
        long lz = z;
        if (lx * lx + lz * lz < 10000L) {
            String pillarID = String.format("%d_%d", x, z);
            CompoundTag pillar = WorldConfig.getCompoundTag((ModCore)BetterEnd.C, (String)"pillars");
            boolean haveValue = pillar.contains(pillarID);
            int n = minY = haveValue ? pillar.getInt(pillarID) : world.getChunk(x >> 4, z >> 4).getHeight(Heightmap.Types.WORLD_SURFACE, x & 0xF, z);
            if (!haveValue) {
                pillar.putInt(pillarID, minY);
                WorldConfig.saveFile((ModCore)BetterEnd.C);
            }
        } else {
            minY = world.getChunk(x >> 4, z >> 4).getHeight(Heightmap.Types.WORLD_SURFACE, x & 0xF, z);
        }
        GeneratorOptions.setDirectSpikeHeight();
        int maxY = minY + spike.getHeight() - 64;
        if (GeneratorOptions.replacePillars() && this.be_radiusInRange(radius)) {
            StructureTemplate base = EndStructureHelper.readStructure(BetterEnd.C.mk("pillars/pillar_base_" + --radius));
            String path = "pillars/pillar_top_" + radius + (spike.isGuarded() ? "_cage" : "");
            StructureTemplate top = EndStructureHelper.readStructure(BetterEnd.C.mk(path));
            Vec3i side = base.getSize();
            BlockPos pos1 = new BlockPos(x - (side.getX() >> 1), minY - 3, z - (side.getZ() >> 1));
            minY = pos1.getY() + side.getY();
            side = top.getSize();
            BlockPos pos2 = new BlockPos(x - (side.getX() >> 1), maxY, z - (side.getZ() >> 1));
            maxY = pos2.getY();
            StructurePlaceSettings data = new StructurePlaceSettings();
            base.placeInWorld(world, pos1, pos1, data, random, 2);
            top.placeInWorld(world, pos2, pos2, data, random, 2);
            int r2 = radius * radius + 1;
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            for (int px = -radius; px <= radius; ++px) {
                mut.setX(x + px);
                int x2 = px * px;
                for (int pz = -radius; pz <= radius; ++pz) {
                    mut.setZ(z + pz);
                    int z2 = pz * pz;
                    if (x2 + z2 > r2) continue;
                    for (int py = minY; py < maxY; ++py) {
                        mut.setY(py);
                        if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                        if ((px == radius || px == -radius || pz == radius || pz == -radius) && random.nextInt(24) == 0) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.CRYING_OBSIDIAN);
                            continue;
                        }
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.OBSIDIAN);
                    }
                }
            }
        } else {
            minY -= 15;
            int r2 = radius * radius + 1;
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            for (int px = -radius; px <= radius; ++px) {
                mut.setX(x + px);
                int x2 = px * px;
                for (int pz = -radius; pz <= radius; ++pz) {
                    mut.setZ(z + pz);
                    int z2 = pz * pz;
                    if (x2 + z2 > r2) continue;
                    for (int py = minY; py < maxY; ++py) {
                        mut.setY(py);
                        if (!world.getBlockState((BlockPos)mut).canBeReplaced()) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.OBSIDIAN);
                    }
                }
            }
            mut.setX(x);
            mut.setZ(z);
            mut.setY(maxY);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.BEDROCK);
            EndCrystal crystal = (EndCrystal)EntityType.END_CRYSTAL.create((Level)world.getLevel());
            crystal.setBeamTarget(config.getCrystalBeamTarget());
            crystal.setInvulnerable(config.isCrystalInvulnerable());
            crystal.moveTo((double)x + 0.5, (double)(maxY + 1), (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
            world.addFreshEntity((Entity)crystal);
            if (spike.isGuarded()) {
                for (int px = -2; px <= 2; ++px) {
                    boolean bl = Mth.abs((int)px) == 2;
                    for (int pz = -2; pz <= 2; ++pz) {
                        boolean bl2 = Mth.abs((int)pz) == 2;
                        for (int py = 0; py <= 3; ++py) {
                            boolean bl3;
                            boolean bl4 = bl3 = py == 3;
                            if (!bl && !bl2 && !bl3) continue;
                            boolean bl42 = px == -2 || px == 2 || bl3;
                            boolean bl5 = pz == -2 || pz == 2 || bl3;
                            BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.IRON_BARS.defaultBlockState().setValue((Property)IronBarsBlock.NORTH, (Comparable)Boolean.valueOf(bl42 && pz != -2))).setValue((Property)IronBarsBlock.SOUTH, (Comparable)Boolean.valueOf(bl42 && pz != 2))).setValue((Property)IronBarsBlock.WEST, (Comparable)Boolean.valueOf(bl5 && px != -2))).setValue((Property)IronBarsBlock.EAST, (Comparable)Boolean.valueOf(bl5 && px != 2));
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut.set(spike.getCenterX() + px, maxY + py, spike.getCenterZ() + pz), (BlockState)blockState);
                        }
                    }
                }
            }
        }
        info.cancel();
    }

    private boolean be_radiusInRange(int radius) {
        return radius > 1 && radius < 6;
    }
}

