/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.MHelper;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGeyser
extends TextureSheetParticle {
    private final BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
    private boolean changeDir = false;
    private boolean check = true;

    protected ParticleGeyser(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(world, x, y, z, vx, vy, vz);
        this.pickSprite(sprites);
        this.lifetime = MHelper.randRange((int)400, (int)800, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.5f, (float)1.0f, (RandomSource)this.random);
        this.xd = vx;
        this.zd = vz;
        this.yo = y - 0.125;
    }

    public void tick() {
        if (this.yo == this.y || this.age > this.lifetime) {
            this.remove();
        } else {
            if (this.age >= this.lifetime - 200) {
                this.setAlpha((float)(this.lifetime - this.age) / 200.0f);
            }
            this.quadSize += 0.005f;
            this.yd = 0.125;
            if (this.changeDir) {
                this.changeDir = false;
                this.check = false;
                this.xd += MHelper.randRange((double)-0.2, (double)0.2, (RandomSource)this.random);
                this.zd += MHelper.randRange((double)-0.2, (double)0.2, (RandomSource)this.random);
            } else if (this.check) {
                this.changeDir = this.level.getBlockState((BlockPos)this.mut.set(this.x, this.y, this.z)).getFluidState().isEmpty();
                this.xd = 0.0;
                this.zd = 0.0;
            }
        }
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactoryGeyser
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactoryGeyser(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new ParticleGeyser(world, x, y, z, 0.0, 0.125, 0.0, this.sprites);
        }
    }
}

